/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential;

import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.MSNode;
import ffx.potential.bonded.MultiResidue;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.ResidueState;
import java.util.ArrayList;
import java.util.List;

public class AssemblyState {
    private final MolecularAssembly mola;
    private final Residue[] residues;
    private final ResidueState[] resStates;
    private final Atom[] otherAtoms;
    private final double[][] otherCoords;

    public AssemblyState(MolecularAssembly assembly) {
        this.mola = assembly;
        List<Residue> residueList = this.mola.getResidueList();
        ArrayList<Residue> copyResList = new ArrayList<Residue>(residueList);
        List<MSNode> otherNodeList = this.mola.getNodeList();
        otherNodeList.removeAll(residueList);
        for (Residue residue : copyResList) {
            if (!(residue instanceof MultiResidue)) continue;
            List<Residue> subResidues = ((MultiResidue)residue).getConsideredResidues();
            residueList.removeAll(subResidues);
        }
        this.residues = residueList.toArray(new Residue[0]);
        this.resStates = ResidueState.storeAllCoordinates(this.residues);
        ArrayList<Atom> otherAtomList = new ArrayList<Atom>();
        for (MSNode node : otherNodeList) {
            otherAtomList.addAll(node.getAtomList());
        }
        int n = otherAtomList.size();
        this.otherAtoms = new Atom[n];
        otherAtomList.toArray(this.otherAtoms);
        this.otherCoords = ResidueState.storeAtomicCoordinates(this.otherAtoms);
    }

    public static AssemblyState copyState(AssemblyState state) {
        MolecularAssembly assembly = state.getMolecularAssembly();
        AssemblyState orig = new AssemblyState(assembly);
        state.revertState();
        AssemblyState copiedState = new AssemblyState(assembly);
        orig.revertState();
        return copiedState;
    }

    public MolecularAssembly getMolecularAssembly() {
        return this.mola;
    }

    public void revertState() {
        int nResidues = this.residues.length;
        for (int i = 0; i < nResidues; ++i) {
            this.residues[i].revertState(this.resStates[i]);
        }
        int nOthers = this.otherAtoms.length;
        for (int i = 0; i < nOthers; ++i) {
            this.otherAtoms[i].setXYZ(this.otherCoords[i]);
        }
    }
}

