/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential;

import com.sun.jna.NativeLong;
import edu.uiowa.torchani.TorchANILibrary;
import edu.uiowa.torchani.TorchANIUtils;
import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.parameters.ForceField;
import java.util.logging.Logger;

public class ANIEnergy
implements Potential,
LambdaInterface {
    private static final Logger logger = Logger.getLogger(ANIEnergy.class.getName());
    private final int nAtoms;
    private final Atom[] atoms;
    private final NativeLong nAtomsLong;
    private final int[] species;
    private final double[] coordinates;
    private final double[] grad;
    private final String pathToANI;
    private double lambda = 1.0;
    private double energy;
    private final MolecularAssembly molecularAssembly;
    private Potential.STATE state = Potential.STATE.FAST;

    public ANIEnergy(MolecularAssembly molecularAssembly) {
        TorchANIUtils.init();
        System.out.println(" ANI Dir: " + TorchANIUtils.getLibDirectory());
        this.atoms = molecularAssembly.getAtomArray();
        this.nAtoms = this.atoms.length;
        this.nAtomsLong = new NativeLong((long)this.nAtoms);
        this.species = new int[this.nAtoms];
        this.coordinates = new double[3 * this.nAtoms];
        this.grad = new double[3 * this.nAtoms];
        int index = 0;
        for (Atom atom : this.atoms) {
            this.species[index] = atom.getAtomicNumber();
            ++index;
        }
        this.molecularAssembly = molecularAssembly;
        ForceField forceField = molecularAssembly.getForceField();
        this.pathToANI = forceField.getString("ANI_PATH", "ANI2x.pt");
    }

    public double energy(boolean gradient, boolean print) {
        this.getCoordinates(this.coordinates);
        if (gradient) {
            this.energyAndGradient(this.coordinates, this.grad);
            for (int i = 0; i < this.nAtoms; ++i) {
                Atom ai = this.atoms[i];
                int index = 3 * i;
                ai.addToXYZGradient(this.grad[index], this.grad[index + 1], this.grad[index + 2]);
            }
        } else {
            this.energy(this.coordinates);
        }
        return this.energy;
    }

    public double energy(double[] x) {
        this.energy = TorchANILibrary.ctorch((String)this.pathToANI, (NativeLong)this.nAtomsLong, (int[])this.species, (double[])x, (double[])this.grad) * 627.5094738898777;
        return this.energy;
    }

    public double energyAndGradient(double[] x, double[] g) {
        this.energy = TorchANILibrary.ctorch((String)this.pathToANI, (NativeLong)this.nAtomsLong, (int[])this.species, (double[])x, (double[])g) * 627.5094738898777;
        for (int i = 0; i < this.grad.length; ++i) {
            this.grad[i] = g[i] * 627.5094738898777;
        }
        return this.energy;
    }

    public double[] getAcceleration(double[] acceleration) {
        ForceFieldEnergy forceFieldEnergy = this.molecularAssembly.getPotentialEnergy();
        return forceFieldEnergy.getAcceleration(acceleration);
    }

    public double[] getCoordinates(double[] parameters) {
        ForceFieldEnergy forceFieldEnergy = this.molecularAssembly.getPotentialEnergy();
        return forceFieldEnergy.getCoordinates(parameters);
    }

    public void setCoordinates(double[] parameters) {
        ForceFieldEnergy forceFieldEnergy = this.molecularAssembly.getPotentialEnergy();
        forceFieldEnergy.setCoordinates(parameters);
    }

    public Potential.STATE getEnergyTermState() {
        return this.state;
    }

    public void setEnergyTermState(Potential.STATE state) {
        this.state = state;
    }

    public double[] getMass() {
        ForceFieldEnergy forceFieldEnergy = this.molecularAssembly.getPotentialEnergy();
        return forceFieldEnergy.getMass();
    }

    public int getNumberOfVariables() {
        ForceFieldEnergy forceFieldEnergy = this.molecularAssembly.getPotentialEnergy();
        return forceFieldEnergy.getNumberOfVariables();
    }

    public double[] getPreviousAcceleration(double[] previousAcceleration) {
        ForceFieldEnergy forceFieldEnergy = this.molecularAssembly.getPotentialEnergy();
        return forceFieldEnergy.getPreviousAcceleration(previousAcceleration);
    }

    public double[] getScaling() {
        ForceFieldEnergy forceFieldEnergy = this.molecularAssembly.getPotentialEnergy();
        return forceFieldEnergy.getScaling();
    }

    public void setScaling(double[] scaling) {
        ForceFieldEnergy forceFieldEnergy = this.molecularAssembly.getPotentialEnergy();
        forceFieldEnergy.setScaling(scaling);
    }

    public double getTotalEnergy() {
        return this.energy;
    }

    public Potential.VARIABLE_TYPE[] getVariableTypes() {
        ForceFieldEnergy forceFieldEnergy = this.molecularAssembly.getPotentialEnergy();
        return forceFieldEnergy.getVariableTypes();
    }

    public double[] getVelocity(double[] velocity) {
        ForceFieldEnergy forceFieldEnergy = this.molecularAssembly.getPotentialEnergy();
        return forceFieldEnergy.getVelocity(velocity);
    }

    public void setAcceleration(double[] acceleration) {
        ForceFieldEnergy forceFieldEnergy = this.molecularAssembly.getPotentialEnergy();
        forceFieldEnergy.setAcceleration(acceleration);
    }

    public void setPreviousAcceleration(double[] previousAcceleration) {
        ForceFieldEnergy forceFieldEnergy = this.molecularAssembly.getPotentialEnergy();
        forceFieldEnergy.setPreviousAcceleration(previousAcceleration);
    }

    public void setVelocity(double[] velocity) {
        ForceFieldEnergy forceFieldEnergy = this.molecularAssembly.getPotentialEnergy();
        forceFieldEnergy.setVelocity(velocity);
    }

    @Override
    public double getLambda() {
        return this.lambda;
    }

    @Override
    public void setLambda(double lambda) {
        this.lambda = lambda;
    }

    @Override
    public double getd2EdL2() {
        return 0.0;
    }

    @Override
    public double getdEdL() {
        return this.energy;
    }

    @Override
    public void getdEdXdL(double[] gradient) {
        System.arraycopy(this.grad, 0, gradient, 0, gradient.length);
    }
}

