/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.isomorphism.TransformOp;
import org.openscience.cdk.stereo.DoubleBondStereochemistry;
import org.openscience.cdk.stereo.ExtendedCisTrans;
import org.openscience.cdk.stereo.ExtendedTetrahedral;
import org.openscience.cdk.stereo.TetrahedralChirality;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

final class TransformPlan {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(TransformPlan.class);
    private static final String SMIRKS_NEWSTEREO = "smirks.newstereo";
    private final List<TransformOp> ops;
    private final int numNewAtoms;
    private static final IBond.Order[] BOND_ORDERS = new IBond.Order[]{IBond.Order.UNSET, IBond.Order.SINGLE, IBond.Order.DOUBLE, IBond.Order.TRIPLE, IBond.Order.QUADRUPLE, IBond.Order.SINGLE};

    TransformPlan(List<TransformOp> ops) {
        this.numNewAtoms = this.numNewAtoms(ops);
        this.ops = new ArrayList<TransformOp>(ops);
        Collections.sort(this.ops);
        this.optimize(this.ops);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Optimizes op-codes:" + this.ops));
        }
    }

    int requiredAtomCapacity(IAtomContainer mol) {
        return mol.getAtomCount() + this.numNewAtoms + 1;
    }

    boolean apply(IAtomContainer mol, IAtom[] amap) {
        ArrayList stereo = new ArrayList();
        for (IStereoElement se : mol.stereoElements()) {
            stereo.add(se);
        }
        HashMap<IAtom, IBond[]> bonding = new HashMap<IAtom, IBond[]>();
        this.prepare(mol, amap, bonding);
        for (int i = 0; i < this.ops.size(); ++i) {
            TransformOp op = this.ops.get(i);
            if (TransformPlan.apply(mol, amap, op)) continue;
            this.undo(mol, amap, i);
            return false;
        }
        TransformPlan.resyncStereo(mol, stereo, bonding);
        return true;
    }

    void clear() {
        this.ops.clear();
    }

    public String toString() {
        return this.ops.toString();
    }

    private void prepare(IAtomContainer mol, IAtom[] amap, Map<IAtom, IBond[]> bonding) {
        for (IAtom atom : mol.atoms()) {
            atom.clear(1153);
        }
        for (int i = 1; i < amap.length; ++i) {
            if (amap[i] == null) continue;
            amap[i].set(128);
        }
        if (mol.stereoElements().iterator().hasNext()) {
            for (IStereoElement se : mol.stereoElements()) {
                IAtom focus;
                if (se.getConfigClass() == 16896) {
                    focus = (IAtom)se.getFocus();
                    bonding.put(focus, TransformPlan.getBondArray(focus));
                    continue;
                }
                if (se.getConfigClass() != 8448) continue;
                focus = (IBond)se.getFocus();
                bonding.put(focus.getBegin(), TransformPlan.getBondArray(focus.getBegin()));
                bonding.put(focus.getEnd(), TransformPlan.getBondArray(focus.getEnd()));
            }
        }
    }

    private static IBond[] getBondArray(IAtom focus) {
        IBond[] nbors = new IBond[focus.getBondCount()];
        int i = 0;
        for (IBond bond : focus.bonds()) {
            nbors[i++] = bond;
        }
        return nbors;
    }

    private void optimize(List<TransformOp> ops) {
        int i;
        for (i = ops.size() - 1; i > 2; --i) {
            if (!this.canDoReplaceAtom(ops.get(i - 3), ops.get(i - 2), ops.get(i - 1), ops.get(i))) continue;
            i = this.optimizeReplaceAtom(ops, i);
        }
        for (i = ops.size() - 1; i > 1; --i) {
            if (!this.canDoReplaceH(ops.get(i - 2), ops.get(i - 1), ops.get(i))) continue;
            i = this.optimizeReplaceHydrogen(ops, i);
        }
        for (i = ops.size() - 1; i > 0; --i) {
            if (!this.deleteBondedAtom(ops.get(i - 1), ops.get(i))) continue;
            ops.remove(i - 1);
        }
    }

    private int optimizeReplaceHydrogen(List<TransformOp> ops, int i) {
        ops.set(i - 2, new TransformOp(TransformOp.Type.ReplaceHydrogen, ops.get((int)(i - 2)).a, ops.get((int)(i - 1)).a, ops.get((int)(i - 1)).b, ops.get((int)(i - 1)).c));
        if (ops.get((int)(i - 1)).d != 0) {
            ops.set(i - 1, new TransformOp(TransformOp.Type.Aromatic, ops.get((int)(i - 1)).a, 1));
        } else {
            ops.remove(i--);
        }
        ops.remove(i--);
        return i;
    }

    private int optimizeReplaceAtom(List<TransformOp> ops, int i) {
        int from = ops.get((int)(i - 3)).a;
        int to = ops.get((int)i).a;
        ops.set(i - 3, new TransformOp(TransformOp.Type.ReplaceAtom, ops.get((int)i).a, ops.get((int)(i - 3)).b, ops.get((int)(i - 3)).c, ops.get((int)(i - 3)).d));
        if (ops.get((int)(i - 1)).c != ops.get((int)(i - 2)).c) {
            ops.set(i - 2, new TransformOp(TransformOp.Type.BondOrder, ops.get((int)(i - 1)).a, ops.get((int)(i - 1)).b, ops.get((int)(i - 2)).c));
        } else {
            ops.remove(i--);
        }
        ops.remove(i--);
        ops.remove(i--);
        for (int j = i; j < ops.size(); ++j) {
            ops.set(j, ops.get(j).remap(from, to));
        }
        return i;
    }

    private boolean deleteBondedAtom(TransformOp fst, TransformOp snd) {
        return snd.type == TransformOp.Type.DeleteAtom && fst.type == TransformOp.Type.DeleteBond && (snd.a == fst.a || snd.a == fst.b);
    }

    private boolean canReuseBond(TransformOp newBnd, TransformOp delBnd) {
        if (newBnd.type != TransformOp.Type.NewBond) {
            return false;
        }
        if (delBnd.type != TransformOp.Type.DeleteBond) {
            return false;
        }
        return newBnd.a == delBnd.a || newBnd.a == delBnd.b || newBnd.b == delBnd.a || newBnd.b == delBnd.b;
    }

    private boolean canDoReplaceAtom(TransformOp op1, TransformOp op2, TransformOp op3, TransformOp op4) {
        return op1.type == TransformOp.Type.NewAtom && this.canReuseBond(op2, op3) && op4.type == TransformOp.Type.DeleteAtom;
    }

    private boolean canDoReplaceH(TransformOp adjH, TransformOp newAtm, TransformOp newBnd) {
        return newAtm.type == TransformOp.Type.NewAtom && newBnd.type == TransformOp.Type.NewBond && adjH.type == TransformOp.Type.AdjustH && adjH.b == -1 && newAtm.a == newBnd.getOtherIdx(adjH.a) && (newBnd.c == 1 || newBnd.c == 5);
    }

    private int numNewAtoms(List<TransformOp> ops) {
        int count = 0;
        for (TransformOp op : ops) {
            if (op.type != TransformOp.Type.NewAtom && op.type != TransformOp.Type.PromoteH) continue;
            ++count;
        }
        return count;
    }

    private static boolean apply(IAtomContainer mol, IAtom[] amap, TransformOp op) {
        switch (op.type) {
            case NewAtom: {
                amap[op.a] = TransformPlan.newAtom(mol, op.b, op.c, op.d);
                break;
            }
            case ReplaceAtom: {
                TransformPlan.replaceAtom(mol, amap, op);
                break;
            }
            case ReplaceHydrogen: {
                if (TransformPlan.replaceHydrogen(mol, amap, op)) break;
                return false;
            }
            case NewBond: {
                if (amap[op.a] == null || amap[op.b] == null) {
                    throw new IllegalStateException(op + " atoms={null=" + (amap[op.a] == null) + ",null=" + (amap[op.b] == null) + "}");
                }
                if (amap[op.a].getBond(amap[op.b]) != null) {
                    return false;
                }
                mol.addBond(amap[op.a].getIndex(), amap[op.b].getIndex(), BOND_ORDERS[op.c]);
                if (op.c == 5) {
                    mol.getBond(mol.getBondCount() - 1).setIsAromatic(true);
                }
                TransformPlan.markBondingChanged(amap[op.a], amap[op.b]);
                break;
            }
            case OverwriteBond: {
                if (amap[op.a] == null || amap[op.b] == null) {
                    throw new IllegalStateException(op + " atoms={null=" + (amap[op.a] == null) + ",null=" + (amap[op.b] == null) + "}");
                }
                IBond tmpBond = amap[op.a].getBond(amap[op.b]);
                if (tmpBond == null) {
                    mol.addBond(amap[op.a].getIndex(), amap[op.b].getIndex(), BOND_ORDERS[op.c]);
                    tmpBond = mol.getBond(mol.getBondCount() - 1);
                } else {
                    tmpBond.setOrder(BOND_ORDERS[op.c]);
                }
                if (op.c == 5) {
                    tmpBond.setIsAromatic(true);
                }
                TransformPlan.markBondingChanged(amap[op.a], amap[op.b]);
                break;
            }
            case DeleteAtom: {
                mol.removeAtom(amap[op.a]);
                TransformPlan.markBondingChanged(amap[op.a]);
                break;
            }
            case DeleteBond: {
                mol.removeBond(amap[op.a].getBond(amap[op.b]));
                TransformPlan.markBondingChanged(amap[op.a], amap[op.b]);
                break;
            }
            case BondOrder: {
                amap[op.a].getBond(amap[op.b]).setOrder(BOND_ORDERS[op.c]);
                TransformPlan.markBondingChanged(amap[op.a], amap[op.b]);
                break;
            }
            case Element: {
                amap[op.a].setAtomicNumber(Integer.valueOf(op.b));
                break;
            }
            case Aromatic: {
                amap[op.a].setIsAromatic(op.b != 0);
                break;
            }
            case AromaticBond: {
                amap[op.a].getBond(amap[op.b]).setIsAromatic(op.c != 0);
                break;
            }
            case Charge: {
                amap[op.a].setFormalCharge(Integer.valueOf(op.b));
                break;
            }
            case ImplH: {
                amap[op.a].setImplicitHydrogenCount(Integer.valueOf(op.b));
                TransformPlan.markBondingChanged(amap[op.a]);
                break;
            }
            case TotalH: {
                if (!TransformPlan.setTotalH(amap[op.a], op.b)) {
                    return false;
                }
                amap[op.a].set(1);
                TransformPlan.markBondingChanged(amap[op.a]);
                break;
            }
            case AdjustH: {
                if (!TransformPlan.adjustHydrogenCount(mol, amap[op.a], op.b)) {
                    return false;
                }
                amap[op.a].set(1);
                TransformPlan.markBondingChanged(amap[op.a]);
                break;
            }
            case MoveH: {
                if (!TransformPlan.moveHydrogen(mol, amap[op.a], amap[op.b])) {
                    return false;
                }
                amap[op.a].set(1);
                amap[op.b].set(1);
                TransformPlan.markBondingChanged(amap[op.a], amap[op.b]);
                break;
            }
            case PromoteH: {
                amap[op.a].set(1);
                if (TransformPlan.promoteHydrogen(mol, amap, amap[op.a], op.b)) break;
                return false;
            }
            case Mass: {
                amap[op.a].setMassNumber(Integer.valueOf(op.b));
                break;
            }
            case Tetrahedral: {
                TransformPlan.setLeftHandedTetrahedral(mol, amap, op);
                break;
            }
            case DbTogether: 
            case DbOpposite: {
                TransformPlan.setDbStereo(mol, amap, op);
                break;
            }
            case RemoveUnmapped: {
                TransformPlan.removedUnmappedFragments(mol);
                break;
            }
            case RecomputeHydrogens: {
                TransformPlan.recomputeHydrogens(mol);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static void removedUnmappedFragments(IAtomContainer mol) {
        ArrayDeque<IAtom> queue = new ArrayDeque<IAtom>();
        for (IAtom atom : mol.atoms()) {
            if (!atom.is(128)) continue;
            for (IBond bond : atom.bonds()) {
                IAtom nbor = bond.getOther(atom);
                if (nbor.is(128)) continue;
                queue.add(nbor);
            }
        }
        while (!queue.isEmpty()) {
            IAtom atom = (IAtom)queue.poll();
            atom.set(128);
            for (IBond bond : atom.bonds()) {
                IAtom nbor = bond.getOther(atom);
                if (nbor.is(128)) continue;
                queue.add(nbor);
            }
        }
        ArrayList<IAtom> unmapped = new ArrayList<IAtom>();
        for (IAtom atom : mol.atoms()) {
            if (atom.is(128)) continue;
            unmapped.add(atom);
        }
        for (IAtom atom : unmapped) {
            mol.removeAtom(atom);
        }
    }

    private static void recomputeHydrogens(IAtomContainer mol) {
        CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance((IChemObjectBuilder)mol.getBuilder());
        for (IAtom atom : mol.atoms()) {
            if (!atom.is(128) || atom.is(1)) continue;
            try {
                Integer total;
                atom.setImplicitHydrogenCount(null);
                IAtomType matched = matcher.findMatchingAtomType(mol, atom);
                if (matched == null || (total = matched.getFormalNeighbourCount()) == null) continue;
                int implH = Math.max(0, total - atom.getBondCount());
                atom.setImplicitHydrogenCount(Integer.valueOf(implH));
            }
            catch (CDKException ex) {
                LoggingToolFactory.createLoggingTool(TransformPlan.class).error((Object)ex);
            }
        }
    }

    private static boolean setTotalH(IAtom atm, int hcnt) {
        int numExplH = 0;
        for (Object bond : atm.bonds()) {
            IAtom atom = bond.getOther(atm);
            if (atom.getAtomicNumber() != 1) continue;
            ++numExplH;
        }
        if (hcnt >= numExplH) {
            atm.setImplicitHydrogenCount(Integer.valueOf(hcnt - numExplH));
        } else {
            atm.setImplicitHydrogenCount(Integer.valueOf(0));
            ArrayList<IAtom> terminalHydrogens = new ArrayList<IAtom>(numExplH);
            for (IBond bond : atm.bonds()) {
                IAtom nbor = bond.getOther(atm);
                if (nbor.getAtomicNumber() != 1 || nbor.getBondCount() != 1) continue;
                terminalHydrogens.add(nbor);
            }
            if (numExplH - terminalHydrogens.size() > hcnt) {
                return false;
            }
            IAtomContainer mol = atm.getContainer();
            for (IAtom hatm : terminalHydrogens) {
                mol.removeAtom(hatm);
                if (--numExplH != hcnt) continue;
                break;
            }
        }
        return true;
    }

    private static void resyncStereo(IAtomContainer mol, List<IStereoElement<?, ?>> stereo, Map<IAtom, IBond[]> bonding) {
        List stereos;
        if (!stereo.isEmpty()) {
            boolean modified = false;
            ArrayList<Object> updatedStereo = new ArrayList<Object>();
            block7: for (IStereoElement<?, ?> se : stereo) {
                switch (se.getConfigClass()) {
                    case 16896: 
                    case 17664: 
                    case 20992: 
                    case 24832: {
                        Object bond2;
                        if (!TransformPlan.bondingChanged(se.getFocus())) {
                            updatedStereo.add(se);
                            break;
                        }
                        modified = true;
                        boolean okay = true;
                        IStereoElement<?, ?> atomStereo = se;
                        IAtom focus = (IAtom)atomStereo.getFocus();
                        HashSet oldNbors = new HashSet(atomStereo.getCarriers());
                        HashSet<IAtom> newNbors = new HashSet<IAtom>();
                        for (Object bond2 : focus.bonds()) {
                            IAtom nbor;
                            if (bond2.isAromatic()) {
                                okay = false;
                            }
                            if (oldNbors.remove(nbor = bond2.getOther(focus))) continue;
                            newNbors.add(nbor);
                        }
                        if (oldNbors.size() > newNbors.size()) {
                            oldNbors.remove(focus);
                        }
                        if (!okay || oldNbors.size() != 1 || newNbors.size() != 1) continue block7;
                        HashMap<Object, Object> mapping = new HashMap<Object, Object>();
                        mapping.put(focus, focus);
                        bond2 = atomStereo.getCarriers().iterator();
                        while (bond2.hasNext()) {
                            IAtom old = (IAtom)bond2.next();
                            mapping.put(old, old);
                        }
                        mapping.put((IChemObject)oldNbors.iterator().next(), (IChemObject)newNbors.iterator().next());
                        ArrayList<IAtom> newLigands = new ArrayList<IAtom>();
                        for (IAtom atom : atomStereo.getCarriers()) {
                            newLigands.add((IAtom)mapping.get(atom));
                        }
                        updatedStereo.add(new TetrahedralChirality(focus, newLigands.toArray(new IAtom[0]), se.getConfig()));
                        break;
                    }
                    case 17408: {
                        if (!TransformPlan.bondingChanged((IChemObject)((IBond)se.getFocus()).getBegin()) && !TransformPlan.bondingChanged((IChemObject)((IBond)se.getFocus()).getEnd())) {
                            updatedStereo.add(se);
                            break;
                        }
                        modified = true;
                        break;
                    }
                    case 8448: {
                        if (!TransformPlan.bondingChanged((IChemObject)((IBond)se.getFocus()).getBegin()) && !TransformPlan.bondingChanged((IChemObject)((IBond)se.getFocus()).getEnd())) {
                            updatedStereo.add(se);
                            break;
                        }
                        modified = true;
                        IStereoElement<?, ?> bondStereo = se;
                        IAtom beg = ((IBond)se.getFocus()).getBegin();
                        IAtom end = ((IBond)se.getFocus()).getEnd();
                        boolean okay = ((IBond)bondStereo.getFocus()).getOrder() == IBond.Order.DOUBLE && !((IBond)bondStereo.getFocus()).isAromatic() && beg.getBond(end) == bondStereo.getFocus();
                        HashSet<IBond> oldBegNbors = new HashSet<IBond>(Arrays.asList(bonding.get(beg)));
                        HashSet<IBond> oldEndNbors = new HashSet<IBond>(Arrays.asList(bonding.get(end)));
                        HashSet<IBond> newBegNbors = new HashSet<IBond>();
                        HashSet<IBond> newEndNbors = new HashSet<IBond>();
                        HashMap<Object, Object> mapping = new HashMap<Object, Object>();
                        for (IBond bond : beg.bonds()) {
                            if (bond == bondStereo.getFocus()) continue;
                            if (!oldBegNbors.remove(bond)) {
                                newBegNbors.add(bond);
                            } else {
                                mapping.put(bond, bond);
                            }
                            if (bond.getOrder() == IBond.Order.SINGLE && !bond.isAromatic()) continue;
                            okay = false;
                        }
                        for (IBond bond : end.bonds()) {
                            if (bond == bondStereo.getFocus()) continue;
                            if (!oldEndNbors.remove(bond)) {
                                newEndNbors.add(bond);
                            } else {
                                mapping.put(bond, bond);
                            }
                            if (bond.getOrder() == IBond.Order.SINGLE && !bond.isAromatic()) continue;
                            okay = false;
                        }
                        oldBegNbors.remove(bondStereo.getFocus());
                        oldEndNbors.remove(bondStereo.getFocus());
                        if (oldBegNbors.size() == 1 && newBegNbors.size() == 1) {
                            mapping.put((IChemObject)oldBegNbors.iterator().next(), (IChemObject)newBegNbors.iterator().next());
                        } else if (oldBegNbors.size() != 0 || newBegNbors.size() != 0) {
                            okay = false;
                        }
                        if (oldEndNbors.size() == 1 && newEndNbors.size() == 1) {
                            mapping.put((IChemObject)oldEndNbors.iterator().next(), (IChemObject)newEndNbors.iterator().next());
                        } else if (oldEndNbors.size() != 0 || newEndNbors.size() != 0) {
                            okay = false;
                        }
                        if (!okay) continue block7;
                        updatedStereo.add(se.map(mapping));
                        break;
                    }
                    case 17152: {
                        IAtom[] ends = ExtendedTetrahedral.findTerminalAtoms((IAtomContainer)mol, (IAtom)((IAtom)se.getFocus()));
                        if (!(TransformPlan.bondingChanged(se.getFocus()) || TransformPlan.bondingChanged((IChemObject)ends[0]) || TransformPlan.bondingChanged((IChemObject)ends[1]))) {
                            updatedStereo.add(se);
                            break;
                        }
                        modified = true;
                        break;
                    }
                    case 8704: {
                        IAtom[] ends = ExtendedCisTrans.findTerminalAtoms((IAtomContainer)mol, (IBond)((IBond)se.getFocus()));
                        if (!(TransformPlan.bondingChanged((IChemObject)((IBond)se.getFocus()).getBegin()) || TransformPlan.bondingChanged((IChemObject)((IBond)se.getFocus()).getEnd()) || ends == null || TransformPlan.bondingChanged((IChemObject)ends[0]) || TransformPlan.bondingChanged((IChemObject)ends[1]))) {
                            updatedStereo.add(se);
                            break;
                        }
                        modified = true;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled stereochemistry type");
                    }
                }
            }
            if (modified) {
                mol.setStereoElements(updatedStereo);
            }
        }
        if ((stereos = (List)mol.getProperty((Object)SMIRKS_NEWSTEREO)) != null) {
            for (IStereoElement se : stereos) {
                mol.addStereoElement(se);
            }
        }
        mol.removeProperty((Object)SMIRKS_NEWSTEREO);
    }

    private static void removeStereo(IAtomContainer mol, IChemObject atom) {
        ArrayList<IStereoElement> stereo = new ArrayList<IStereoElement>();
        for (IStereoElement se : mol.stereoElements()) {
            if (se.getFocus().equals(atom)) continue;
            stereo.add(se);
        }
        mol.setStereoElements(stereo);
    }

    private static void setLeftHandedTetrahedral(IAtomContainer mol, IAtom[] amap, TransformOp op) {
        ArrayList<TetrahedralChirality> newStereo;
        IAtom focus = amap[op.a];
        TransformPlan.removeStereo(mol, (IChemObject)focus);
        IAtom[] carriers = new IAtom[]{amap[op.b], amap[op.c], amap[op.d], focus};
        if (focus.getBondCount() == 4) {
            for (IBond bond : focus.bonds()) {
                IAtom nbor = bond.getOther(focus);
                if (nbor.equals(amap[op.b]) || nbor.equals(amap[op.c]) || nbor.equals(amap[op.d])) continue;
                carriers[3] = nbor;
            }
        }
        if ((newStereo = (ArrayList<TetrahedralChirality>)mol.getProperty((Object)SMIRKS_NEWSTEREO)) == null) {
            newStereo = new ArrayList<TetrahedralChirality>();
            mol.setProperty((Object)SMIRKS_NEWSTEREO, newStereo);
        }
        newStereo.add(new TetrahedralChirality(focus, carriers, ITetrahedralChirality.Stereo.ANTI_CLOCKWISE));
    }

    private static void setDbStereo(IAtomContainer mol, IAtom[] amap, TransformOp op) {
        ArrayList<DoubleBondStereochemistry> newStereo;
        IBond dbBond = amap[op.a].getBond(amap[op.b]);
        if (dbBond == null) {
            throw new IllegalStateException();
        }
        TransformPlan.removeStereo(mol, (IChemObject)dbBond);
        IBond begNbor = amap[op.a].getBond(amap[op.c]);
        IBond endNBor = amap[op.b].getBond(amap[op.d]);
        if (begNbor == null || endNBor == null) {
            throw new IllegalStateException();
        }
        if (dbBond.getEnd().equals(amap[op.a]) && dbBond.getBegin().equals(amap[op.b])) {
            IBond tmp = begNbor;
            begNbor = endNBor;
            endNBor = tmp;
        }
        if ((newStereo = (ArrayList<DoubleBondStereochemistry>)mol.getProperty((Object)SMIRKS_NEWSTEREO)) == null) {
            newStereo = new ArrayList<DoubleBondStereochemistry>();
            mol.setProperty((Object)SMIRKS_NEWSTEREO, newStereo);
        }
        if (op.type == TransformOp.Type.DbTogether) {
            newStereo.add(new DoubleBondStereochemistry(dbBond, new IBond[]{begNbor, endNBor}, IDoubleBondStereochemistry.Conformation.TOGETHER));
        } else {
            newStereo.add(new DoubleBondStereochemistry(dbBond, new IBond[]{begNbor, endNBor}, IDoubleBondStereochemistry.Conformation.OPPOSITE));
        }
    }

    private static void replaceAtom(IAtomContainer mol, IAtom[] amap, TransformOp op) {
        amap[op.a].setMassNumber(null);
        amap[op.a].setAtomicNumber(Integer.valueOf(op.b));
        amap[op.a].setImplicitHydrogenCount(Integer.valueOf(op.c));
        amap[op.a].setIsAromatic(op.d != 0);
        TransformPlan.removeUnmappedBonds(amap[op.a], mol);
    }

    private static boolean replaceHydrogen(IAtomContainer mol, IAtom[] amap, TransformOp op) {
        IAtom atom = amap[op.a];
        IAtom hAtm = null;
        int hcnt = atom.getImplicitHydrogenCount();
        if (hcnt == 0) {
            for (IBond bond : atom.bonds()) {
                IAtom nbor;
                if (bond.getOrder() != IBond.Order.SINGLE || !TransformPlan.isUnmappedExplH(nbor = bond.getOther(atom))) continue;
                hAtm = nbor;
                break;
            }
            if (hAtm == null) {
                return false;
            }
        } else {
            amap[op.a].setImplicitHydrogenCount(Integer.valueOf(hcnt - 1));
        }
        if (hAtm != null) {
            TransformPlan.removeUnmappedBonds(hAtm, mol);
            hAtm.setMassNumber(null);
            hAtm.setAtomicNumber(Integer.valueOf(op.c));
            hAtm.setImplicitHydrogenCount(Integer.valueOf(op.d));
            hAtm.setFormalCharge(Integer.valueOf(0));
            hAtm.setIsAromatic(false);
            amap[op.b] = hAtm;
        } else {
            IAtom newAtom = mol.getBuilder().newAtom();
            newAtom.setAtomicNumber(Integer.valueOf(op.c));
            newAtom.setImplicitHydrogenCount(Integer.valueOf(op.d));
            mol.addAtom(newAtom);
            amap[op.b] = mol.getAtom(mol.getAtomCount() - 1);
            mol.addBond(atom.getIndex(), amap[op.b].getIndex(), IBond.Order.SINGLE);
        }
        return true;
    }

    private static void removeUnmappedBonds(IAtom hAtm, IAtomContainer mol) {
        ArrayList<IBond> bondsToDelete = new ArrayList<IBond>();
        for (IBond bond : hAtm.bonds()) {
            if (!TransformPlan.isUnmapped(bond.getOther(hAtm))) continue;
            bondsToDelete.add(bond);
        }
        for (IBond bond : bondsToDelete) {
            mol.removeBond(bond);
        }
    }

    private static IAtom newAtom(IAtomContainer mol, int elem, int hnct, int arom) {
        IAtom atom = mol.getBuilder().newAtom();
        atom.setAtomicNumber(Integer.valueOf(elem));
        atom.setImplicitHydrogenCount(Integer.valueOf(hnct));
        atom.setIsAromatic(arom != 0);
        atom.set(128);
        mol.addAtom(atom);
        return mol.getAtom(mol.getAtomCount() - 1);
    }

    private static boolean adjustHydrogenCount(IAtomContainer mol, IAtom atom, int adjustment) {
        int updatedHcnt = atom.getImplicitHydrogenCount() + adjustment;
        if (updatedHcnt >= 0) {
            atom.setImplicitHydrogenCount(Integer.valueOf(updatedHcnt));
        } else {
            if (!TransformPlan.removeExplH(mol, atom, -updatedHcnt)) {
                return false;
            }
            atom.setImplicitHydrogenCount(Integer.valueOf(0));
        }
        return true;
    }

    private static boolean removeExplH(IAtomContainer mol, IAtom atom, int required) {
        HashSet<IAtom> deleted = new HashSet<IAtom>();
        for (IBond bond : atom.bonds()) {
            IAtom nbor;
            if (bond.getOrder() != IBond.Order.SINGLE || !TransformPlan.isUnmappedExplH(nbor = bond.getOther(atom))) continue;
            deleted.add(nbor);
            if (deleted.size() != required) continue;
            break;
        }
        if (deleted.size() != required) {
            return false;
        }
        for (IAtom a : deleted) {
            mol.removeAtom(a);
        }
        return true;
    }

    private static boolean moveHydrogen(IAtomContainer mol, IAtom from, IAtom to) {
        if (from.getImplicitHydrogenCount() != 0) {
            from.setImplicitHydrogenCount(Integer.valueOf(from.getImplicitHydrogenCount() - 1));
            to.setImplicitHydrogenCount(Integer.valueOf(to.getImplicitHydrogenCount() + 1));
            return true;
        }
        return TransformPlan.moveExplH(mol, from, to);
    }

    private static boolean promoteHydrogen(IAtomContainer mol, IAtom[] amap, IAtom from, int to) {
        if (from.getImplicitHydrogenCount() != 0) {
            from.setImplicitHydrogenCount(Integer.valueOf(from.getImplicitHydrogenCount() - 1));
            IAtom atom = mol.getBuilder().newAtom();
            atom.setAtomicNumber(Integer.valueOf(1));
            atom.setImplicitHydrogenCount(Integer.valueOf(0));
            mol.addAtom(atom);
            amap[to] = mol.getAtom(mol.getAtomCount() - 1);
            return true;
        }
        if (TransformPlan.moveExplH(mol, from, null)) {
            amap[to] = from;
            return true;
        }
        return false;
    }

    private static boolean moveExplH(IAtomContainer mol, IAtom src, IAtom dst) {
        IAtom hAtm = null;
        IBond hBnd = null;
        for (IBond bond : src.bonds()) {
            IAtom nbor;
            if (bond.getOrder() != IBond.Order.SINGLE || !TransformPlan.isUnmappedExplH(nbor = bond.getOther(src))) continue;
            hBnd = bond;
            hAtm = nbor;
            break;
        }
        if (hAtm == null) {
            return false;
        }
        mol.removeBond(hBnd);
        if (dst != null) {
            mol.addBond(dst.getIndex(), hAtm.getIndex(), IBond.Order.SINGLE);
        }
        return true;
    }

    private static boolean isUnmappedExplH(IAtom atom) {
        if (atom.getAtomicNumber() != 1) {
            return false;
        }
        return TransformPlan.isUnmapped(atom);
    }

    private static boolean isUnmapped(IAtom atom) {
        return !atom.is(128);
    }

    private static void markBondingChanged(IAtom atom) {
        atom.set(1024);
    }

    private static void markBondingChanged(IAtom beg, IAtom end) {
        beg.set(1024);
        end.set(1024);
    }

    private static boolean bondingChanged(IChemObject chemobj) {
        return chemobj.is(1024);
    }

    private void undo(IAtomContainer mol, IAtom[] amap, TransformOp op) {
        switch (op.type) {
            case NewAtom: {
                mol.removeAtom(amap[op.a]);
                break;
            }
            case NewBond: {
                mol.removeBond(amap[op.a].getBond(amap[op.b]));
                break;
            }
            case AdjustH: {
                if (TransformPlan.adjustHydrogenCount(mol, amap[op.a], -op.b)) break;
                throw new IllegalStateException("Was not able to undo AdjustH");
            }
            case MoveH: {
                if (TransformPlan.moveHydrogen(mol, amap[op.b], amap[op.a])) break;
                throw new IllegalStateException("Was not able to undo MoveH");
            }
            default: {
                throw new IllegalStateException("OpCode cannot be undone: " + op);
            }
        }
    }

    private void undo(IAtomContainer mol, IAtom[] amap, int n) {
        for (int i = n - 1; i >= 0; --i) {
            this.undo(mol, amap, this.ops.get(i));
        }
    }
}

