/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.Mappings;
import org.openscience.cdk.isomorphism.Pattern;
import org.openscience.cdk.isomorphism.TransformOp;
import org.openscience.cdk.isomorphism.TransformPlan;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class Transform {
    private static final String NO_TRANSFORM_DEFINED = "No transform defined";
    private Pattern pattern;
    private TransformPlan plan;
    private Status status;
    private String message;

    public Transform() {
        this.setError(NO_TRANSFORM_DEFINED);
    }

    Transform(Pattern substructure, List<TransformOp> ops) {
        this.init(substructure, ops, null);
    }

    public void init(Pattern pattern, List<TransformOp> ops, String warning) {
        if (pattern == null || ops == null) {
            throw new NoSuchElementException("Pattern and ops must be provided!");
        }
        this.pattern = pattern;
        this.plan = new TransformPlan(ops);
        if (warning != null && !warning.isEmpty()) {
            this.setWarning(warning);
        } else {
            this.setOk();
        }
    }

    public void init(Pattern pattern, List<TransformOp> ops) {
        this.init(pattern, ops, null);
    }

    private void setOk() {
        this.status = Status.OK;
        this.message = null;
    }

    private void setWarning(String warning) {
        this.status = Status.WARNING;
        this.message = warning;
    }

    public boolean setError(String message) {
        this.status = Status.ERROR;
        this.message = message;
        return false;
    }

    public String message() {
        return this.message;
    }

    public void reset() {
        this.setError(NO_TRANSFORM_DEFINED);
        this.pattern = null;
        this.plan.clear();
    }

    public Iterable<IAtomContainer> apply(final IAtomContainer mol, Mode mode, int limit) {
        if (this.status == Status.ERROR) {
            return Collections.emptyList();
        }
        if (mode == Mode.Exclusive) {
            IAtomContainer cpy = Transform.copyOf(mol);
            if (this.apply(cpy, limit)) {
                return Collections.singletonList(cpy);
            }
            return Collections.emptyList();
        }
        Mappings mappings = this.pattern.matchAll(mol);
        if (mode == Mode.Unique) {
            mappings = mappings.uniqueAtoms();
        }
        if (limit != 0) {
            mappings = mappings.limit(limit);
        }
        final Mappings mappingsCaptured = mappings;
        final IAtom[] amap = new IAtom[this.plan.requiredAtomCapacity(mol)];
        return () -> new Iterator<IAtomContainer>(){
            private final Iterator<int[]> iter;
            private IAtomContainer next;
            {
                this.iter = mappingsCaptured.iterator();
            }

            private IAtomContainer loadNext() {
                if (this.next != null) {
                    return this.next;
                }
                while (this.iter.hasNext()) {
                    IAtomContainer cpy = Transform.copyOf(mol);
                    Transform.this.permute(amap, this.iter.next(), cpy);
                    if (!Transform.this.plan.apply(cpy, amap)) continue;
                    this.next = cpy;
                    break;
                }
                return this.next;
            }

            @Override
            public boolean hasNext() {
                return this.loadNext() != null;
            }

            @Override
            public IAtomContainer next() {
                IAtomContainer res = this.loadNext();
                this.next = null;
                return res;
            }
        };
    }

    public Iterable<IAtomContainer> apply(IAtomContainer mol, Mode mode) {
        return this.apply(mol, mode, 0);
    }

    public boolean apply(IAtomContainer mol, int limit) {
        if (this.status == Status.ERROR) {
            return false;
        }
        IAtom[] atoms = AtomContainerManipulator.getAtomArray((IAtomContainer)mol);
        IAtom[] amap = new IAtom[this.plan.requiredAtomCapacity(mol)];
        boolean changed = false;
        Mappings matches = this.pattern.matchAll(mol).exclusiveAtoms();
        if (limit != 0) {
            matches = matches.limit(limit);
        }
        for (int[] match : matches.toArray()) {
            this.permute(amap, match, atoms);
            if (!this.plan.apply(mol, amap)) continue;
            changed = true;
        }
        return changed;
    }

    public boolean apply(IAtomContainer mol) {
        return this.apply(mol, 0);
    }

    private void permute(IAtom[] amap, int[] match, IAtom[] atoms) {
        for (int i = 0; i < match.length; ++i) {
            amap[i + 1] = atoms[match[i]];
        }
    }

    private void permute(IAtom[] amap, int[] match, IAtomContainer mol) {
        int i;
        for (i = 0; i < match.length; ++i) {
            amap[i + 1] = mol.getAtom(match[i]);
        }
        for (i = 1; i <= match.length; ++i) {
            amap[i].setFlag(128, true);
        }
    }

    private static IAtomContainer copyOf(IAtomContainer mol) {
        try {
            return mol.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Could not clone() molecule");
        }
    }

    private static enum Status {
        OK,
        WARNING,
        ERROR;

    }

    public static enum Mode {
        All,
        Unique,
        Exclusive;

    }
}

