/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

import edu.rit.util.Timer;
import edu.rit.util.TimerTask;
import java.util.Iterator;
import java.util.Vector;

public class TimerThread
extends Thread {
    private static final int INCR = 4;
    private TimeoutInfo[] myQueue = new TimeoutInfo[5];
    private int mySize = 0;
    private boolean iamRunning = true;
    private static TimerThread theDefaultTimerThread = null;

    public static synchronized TimerThread getDefault() {
        if (theDefaultTimerThread == null) {
            theDefaultTimerThread = new TimerThread();
            theDefaultTimerThread.setDaemon(true);
            theDefaultTimerThread.start();
        }
        return theDefaultTimerThread;
    }

    public Timer createTimer(TimerTask theTimerTask) {
        return new Timer(this, theTimerTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        TimerThread timerThread = this;
        synchronized (timerThread) {
            this.iamRunning = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (Thread.currentThread() != this) {
            throw new IllegalStateException("Wrong thread called the run() method");
        }
        try {
            while (this.iamRunning) {
                Vector<TimeoutInfo> theTriggeredTimeouts;
                long now = System.currentTimeMillis();
                TimerThread timerThread = this;
                synchronized (timerThread) {
                    if (this.mySize == 0) {
                        this.wait();
                        now = System.currentTimeMillis();
                    } else {
                        long waitTime = this.myQueue[1].myTimeout - now;
                        if (waitTime > 0L) {
                            this.wait(waitTime);
                            now = System.currentTimeMillis();
                        }
                    }
                    theTriggeredTimeouts = new Vector<TimeoutInfo>();
                    while (this.mySize > 0 && this.myQueue[1].myTimeout <= now) {
                        theTriggeredTimeouts.add(this.myQueue[1]);
                        this.myQueue[1] = this.myQueue[this.mySize];
                        this.myQueue[this.mySize] = null;
                        --this.mySize;
                        this.siftDown(this.mySize);
                    }
                }
                Iterator iter = theTriggeredTimeouts.iterator();
                while (iter.hasNext()) {
                    ((TimeoutInfo)iter.next()).myTimer.trigger(now);
                }
            }
        }
        catch (InterruptedException exc) {
            System.err.println("TimerThread interrupted");
            exc.printStackTrace(System.err);
        }
    }

    synchronized void schedule(long theTimeout, Timer theTimer) {
        if (this.mySize == this.myQueue.length - 1) {
            TimeoutInfo[] newQueue = new TimeoutInfo[this.myQueue.length + 4];
            System.arraycopy(this.myQueue, 1, newQueue, 1, this.mySize);
            this.myQueue = newQueue;
        }
        ++this.mySize;
        this.myQueue[this.mySize] = new TimeoutInfo(theTimeout, theTimer);
        this.siftUp(this.mySize);
        this.notifyAll();
    }

    private void siftUp(int n) {
        int i = n;
        while (i != 1) {
            int p = i / 2;
            if (this.myQueue[p].myTimeout <= this.myQueue[i].myTimeout) break;
            TimeoutInfo temp = this.myQueue[p];
            this.myQueue[p] = this.myQueue[i];
            this.myQueue[i] = temp;
            i = p;
        }
    }

    private void siftDown(int n) {
        int c;
        int i = 1;
        while ((c = 2 * i) <= n) {
            if (c + 1 <= n && this.myQueue[c + 1].myTimeout < this.myQueue[c].myTimeout) {
                ++c;
            }
            if (this.myQueue[i].myTimeout <= this.myQueue[c].myTimeout) break;
            TimeoutInfo temp = this.myQueue[c];
            this.myQueue[c] = this.myQueue[i];
            this.myQueue[i] = temp;
            i = c;
        }
    }

    private static class TimeoutInfo {
        public long myTimeout;
        public Timer myTimer;

        public TimeoutInfo(long theTimeout, Timer theTimer) {
            this.myTimeout = theTimeout;
            this.myTimer = theTimer;
        }
    }
}

