/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

import edu.rit.util.Random;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RandomSample {
    private RandomSample() {
    }

    public static Iterator<Integer> withoutReplacement(final Random prng, final int n, final int N) {
        if (n < 0) {
            throw new IllegalArgumentException("RandomSample.withoutReplacement(): n < 0 illegal");
        }
        if (N < 0) {
            throw new IllegalArgumentException("RandomSample.withoutReplacement(): N < 0 illegal");
        }
        if (n < N) {
            return new Iterator<Integer>(){
                private int i = 0;
                private int M = N;
                private int r = N - n;

                @Override
                public boolean hasNext() {
                    return this.i < n;
                }

                @Override
                public Integer next() {
                    if (this.i >= n) {
                        throw new NoSuchElementException();
                    }
                    ++this.i;
                    double x = prng.nextDouble();
                    double p = 1.0;
                    while (true) {
                        if ((p = p * (double)this.r / (double)this.M) <= x) {
                            int result = N - this.M;
                            --this.M;
                            return result;
                        }
                        --this.M;
                        --this.r;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<Integer>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < N;
            }

            @Override
            public Integer next() {
                if (this.i >= N) {
                    throw new NoSuchElementException();
                }
                return this.i++;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static int withoutReplacement(Random prng, int n, int N, int[] buf) {
        if (n < 0) {
            throw new IllegalArgumentException("RandomSample.withoutReplacement(): n < 0 illegal");
        }
        if (N < 0) {
            throw new IllegalArgumentException("RandomSample.withoutReplacement(): N < 0 illegal");
        }
        if (n < N) {
            int M = N;
            int r = N - n;
            block0: for (int i = 0; i < n; ++i) {
                double x = prng.nextDouble();
                double p = 1.0;
                while (true) {
                    if ((p = p * (double)r / (double)M) <= x) {
                        buf[i] = N - M;
                        --M;
                        continue block0;
                    }
                    --M;
                    --r;
                }
            }
            return n;
        }
        for (int i = 0; i < N; ++i) {
            buf[i] = i;
        }
        return N;
    }

    public static Iterator<Long> withoutReplacement(final Random prng, final int n, final long N) {
        if (n < 0) {
            throw new IllegalArgumentException("RandomSample.withoutReplacement(): n < 0 illegal");
        }
        if (N < 0L) {
            throw new IllegalArgumentException("RandomSample.withoutReplacement(): N < 0 illegal");
        }
        if ((long)n < N) {
            return new Iterator<Long>(){
                private int i = 0;
                private long M = N;
                private long r = N - (long)n;

                @Override
                public boolean hasNext() {
                    return this.i < n;
                }

                @Override
                public Long next() {
                    if (this.i >= n) {
                        throw new NoSuchElementException();
                    }
                    ++this.i;
                    double x = prng.nextDouble();
                    double p = 1.0;
                    while (true) {
                        if ((p = p * (double)this.r / (double)this.M) <= x) {
                            long result = N - this.M;
                            --this.M;
                            return result;
                        }
                        --this.M;
                        --this.r;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<Long>(){
            private long i = 0L;

            @Override
            public boolean hasNext() {
                return this.i < N;
            }

            @Override
            public Long next() {
                if (this.i >= N) {
                    throw new NoSuchElementException();
                }
                return this.i++;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static int withoutReplacement(Random prng, int n, long N, long[] buf) {
        if (n < 0) {
            throw new IllegalArgumentException("RandomSample.withoutReplacement(): n < 0 illegal");
        }
        if (N < 0L) {
            throw new IllegalArgumentException("RandomSample.withoutReplacement(): N < 0 illegal");
        }
        if ((long)n < N) {
            long M = N;
            long r = N - (long)n;
            block0: for (int i = 0; i < n; ++i) {
                double x = prng.nextDouble();
                double p = 1.0;
                while (true) {
                    if ((p = p * (double)r / (double)M) <= x) {
                        buf[i] = N - M;
                        --M;
                        continue block0;
                    }
                    --M;
                    --r;
                }
            }
            return n;
        }
        int i = 0;
        while ((long)i < N) {
            buf[i] = i;
            ++i;
        }
        return (int)N;
    }
}

