/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

import edu.rit.util.Logger;
import java.io.PrintStream;
import java.util.Date;

public class PrintStreamLogger
implements Logger {
    private PrintStream out;

    public PrintStreamLogger() {
        this.out = System.err;
    }

    public PrintStreamLogger(PrintStream out) {
        if (out == null) {
            throw new NullPointerException("PrintStreamLogger(): Print stream is null");
        }
        this.out = out;
    }

    @Override
    public void log(String msg) {
        this.log(System.currentTimeMillis(), msg, null);
    }

    @Override
    public void log(Throwable exc) {
        this.log(System.currentTimeMillis(), null, exc);
    }

    @Override
    public void log(String msg, Throwable exc) {
        this.log(System.currentTimeMillis(), msg, exc);
    }

    @Override
    public void log(long date, String msg) {
        this.log(date, msg, null);
    }

    @Override
    public void log(long date, Throwable exc) {
        this.log(date, null, exc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(long date, String msg, Throwable exc) {
        PrintStream printStream = this.out;
        synchronized (printStream) {
            this.out.print(new Date(date));
            if (msg != null) {
                this.out.print(' ');
                this.out.print(msg);
            }
            this.out.println();
            if (exc != null) {
                exc.printStackTrace(this.out);
            }
        }
    }
}

