/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

public class Packing {
    private Packing() {
    }

    public static int packIntLittleEndian(byte[] src, int srcPos) {
        if (srcPos + 4 > src.length) {
            throw new IndexOutOfBoundsException();
        }
        int rv = 0;
        for (int i = 0; i <= 3; ++i) {
            rv |= (src[srcPos + i] & 0xFF) << i * 8;
        }
        return rv;
    }

    public static int packIntBigEndian(byte[] src, int srcPos) {
        if (srcPos + 4 > src.length) {
            throw new IndexOutOfBoundsException();
        }
        int rv = 0;
        for (int i = 0; i <= 3; ++i) {
            rv |= (src[srcPos + i] & 0xFF) << (3 - i) * 8;
        }
        return rv;
    }

    public static void packIntLittleEndian(byte[] src, int srcPos, int[] dst, int dstPos, int len) {
        if (srcPos + 4 * len > src.length) {
            throw new IndexOutOfBoundsException();
        }
        if (dstPos + len > dst.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            dst[dstPos + i] = Packing.packIntLittleEndian(src, srcPos + 4 * i);
        }
    }

    public static void packIntBigEndian(byte[] src, int srcPos, int[] dst, int dstPos, int len) {
        if (srcPos + 4 * len > src.length) {
            throw new IndexOutOfBoundsException();
        }
        if (dstPos + len > dst.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            dst[dstPos + i] = Packing.packIntBigEndian(src, srcPos + 4 * i);
        }
    }

    public static long packLongLittleEndian(byte[] src, int srcPos) {
        if (srcPos + 8 > src.length) {
            throw new IndexOutOfBoundsException();
        }
        long rv = 0L;
        for (int i = 0; i <= 7; ++i) {
            rv |= ((long)src[srcPos + i] & 0xFFL) << i * 8;
        }
        return rv;
    }

    public static long packLongBigEndian(byte[] src, int srcPos) {
        if (srcPos + 8 > src.length) {
            throw new IndexOutOfBoundsException();
        }
        long rv = 0L;
        for (int i = 0; i <= 7; ++i) {
            rv |= ((long)src[srcPos + i] & 0xFFL) << (7 - i) * 8;
        }
        return rv;
    }

    public static void packLongLittleEndian(byte[] src, int srcPos, long[] dst, int dstPos, int len) {
        if (srcPos + 8 * len > src.length) {
            throw new IndexOutOfBoundsException();
        }
        if (dstPos + len > dst.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            dst[dstPos + i] = Packing.packLongLittleEndian(src, srcPos + 8 * i);
        }
    }

    public static void packLongBigEndian(byte[] src, int srcPos, long[] dst, int dstPos, int len) {
        if (srcPos + 8 * len > src.length) {
            throw new IndexOutOfBoundsException();
        }
        if (dstPos + len > dst.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            dst[dstPos + i] = Packing.packLongBigEndian(src, srcPos + 8 * i);
        }
    }

    public static void unpackIntLittleEndian(int src, byte[] dst, int dstPos) {
        if (dstPos + 4 > dst.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i <= 3; ++i) {
            dst[dstPos + i] = (byte)(src >> i * 8);
        }
    }

    public static void unpackIntBigEndian(int src, byte[] dst, int dstPos) {
        if (dstPos + 4 > dst.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i <= 3; ++i) {
            dst[dstPos + i] = (byte)(src >> (3 - i) * 8);
        }
    }

    public static void unpackIntLittleEndian(int[] src, int srcPos, byte[] dst, int dstPos, int len) {
        if (srcPos + len > src.length) {
            throw new IndexOutOfBoundsException();
        }
        if (dstPos + 4 * len > dst.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            Packing.unpackIntLittleEndian(src[srcPos + i], dst, dstPos + 4 * i);
        }
    }

    public static void unpackIntBigEndian(int[] src, int srcPos, byte[] dst, int dstPos, int len) {
        if (srcPos + len > src.length) {
            throw new IndexOutOfBoundsException();
        }
        if (dstPos + 4 * len > dst.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            Packing.unpackIntBigEndian(src[srcPos + i], dst, dstPos + 4 * i);
        }
    }

    public static void unpackLongLittleEndian(long src, byte[] dst, int dstPos) {
        if (dstPos + 8 > dst.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i <= 7; ++i) {
            dst[dstPos + i] = (byte)(src >> i * 8);
        }
    }

    public static void unpackLongBigEndian(long src, byte[] dst, int dstPos) {
        if (dstPos + 8 > dst.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i <= 7; ++i) {
            dst[dstPos + i] = (byte)(src >> (7 - i) * 8);
        }
    }

    public static void unpackLongLittleEndian(long[] src, int srcPos, byte[] dst, int dstPos, int len) {
        if (srcPos + len > src.length) {
            throw new IndexOutOfBoundsException();
        }
        if (dstPos + 8 * len > dst.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            Packing.unpackLongLittleEndian(src[srcPos + i], dst, dstPos + 8 * i);
        }
    }

    public static void unpackLongBigEndian(long[] src, int srcPos, byte[] dst, int dstPos, int len) {
        if (srcPos + len > src.length) {
            throw new IndexOutOfBoundsException();
        }
        if (dstPos + 8 * len > dst.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            Packing.unpackLongBigEndian(src[srcPos + i], dst, dstPos + 8 * i);
        }
    }
}

