/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

public class Hex {
    private static final char[] int2hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Hex() {
    }

    public static String toString(byte val) {
        StringBuilder buf = new StringBuilder(2);
        buf.append(int2hex[val >> 4 & 0xF]);
        buf.append(int2hex[val & 0xF]);
        return buf.toString();
    }

    public static String toString(char val) {
        StringBuilder buf = new StringBuilder(4);
        buf.append(int2hex[val >> 12 & 0xF]);
        buf.append(int2hex[val >> 8 & 0xF]);
        buf.append(int2hex[val >> 4 & 0xF]);
        buf.append(int2hex[val & 0xF]);
        return buf.toString();
    }

    public static String toString(short val) {
        StringBuilder buf = new StringBuilder(4);
        buf.append(int2hex[val >> 12 & 0xF]);
        buf.append(int2hex[val >> 8 & 0xF]);
        buf.append(int2hex[val >> 4 & 0xF]);
        buf.append(int2hex[val & 0xF]);
        return buf.toString();
    }

    public static String toString(int val) {
        StringBuilder buf = new StringBuilder(8);
        buf.append(int2hex[val >> 28 & 0xF]);
        buf.append(int2hex[val >> 24 & 0xF]);
        buf.append(int2hex[val >> 20 & 0xF]);
        buf.append(int2hex[val >> 16 & 0xF]);
        buf.append(int2hex[val >> 12 & 0xF]);
        buf.append(int2hex[val >> 8 & 0xF]);
        buf.append(int2hex[val >> 4 & 0xF]);
        buf.append(int2hex[val & 0xF]);
        return buf.toString();
    }

    public static String toString(long val) {
        StringBuilder buf = new StringBuilder(16);
        buf.append(int2hex[(int)(val >> 60) & 0xF]);
        buf.append(int2hex[(int)(val >> 56) & 0xF]);
        buf.append(int2hex[(int)(val >> 52) & 0xF]);
        buf.append(int2hex[(int)(val >> 48) & 0xF]);
        buf.append(int2hex[(int)(val >> 44) & 0xF]);
        buf.append(int2hex[(int)(val >> 40) & 0xF]);
        buf.append(int2hex[(int)(val >> 36) & 0xF]);
        buf.append(int2hex[(int)(val >> 32) & 0xF]);
        buf.append(int2hex[(int)(val >> 28) & 0xF]);
        buf.append(int2hex[(int)(val >> 24) & 0xF]);
        buf.append(int2hex[(int)(val >> 20) & 0xF]);
        buf.append(int2hex[(int)(val >> 16) & 0xF]);
        buf.append(int2hex[(int)(val >> 12) & 0xF]);
        buf.append(int2hex[(int)(val >> 8) & 0xF]);
        buf.append(int2hex[(int)(val >> 4) & 0xF]);
        buf.append(int2hex[(int)val & 0xF]);
        return buf.toString();
    }

    public static String toString(byte[] val) {
        return Hex.toString(val, 0, val.length);
    }

    public static String toString(byte[] val, int off, int len) {
        if (off < 0 || len < 0 || off + len > val.length) {
            throw new IndexOutOfBoundsException();
        }
        StringBuilder buf = new StringBuilder(2 * len);
        while (len > 0) {
            buf.append(int2hex[val[off] >> 4 & 0xF]);
            buf.append(int2hex[val[off] & 0xF]);
            ++off;
            --len;
        }
        return buf.toString();
    }

    public static byte toByte(String str) {
        return (byte)Hex.toInt(str);
    }

    public static char toChar(String str) {
        return (char)Hex.toInt(str);
    }

    public static short toShort(String str) {
        return (short)Hex.toInt(str);
    }

    public static int toInt(String str) {
        int result = 0;
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            result = (result << 4) + Hex.hex2int(str.charAt(i));
        }
        return result;
    }

    public static long toLong(String str) {
        long result = 0L;
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            result = (result << 4) + (long)Hex.hex2int(str.charAt(i));
        }
        return result;
    }

    public static byte[] toByteArray(String str) {
        int n = (str.length() + 1) / 2;
        byte[] val = new byte[n];
        Hex.toByteArray(str, val, 0, val.length);
        return val;
    }

    public static void toByteArray(String str, byte[] val) {
        Hex.toByteArray(str, val, 0, val.length);
    }

    public static void toByteArray(String str, byte[] val, int off, int len) {
        if (off < 0 || len < 0 || off + len > val.length) {
            throw new IndexOutOfBoundsException();
        }
        int stroff = str.length() - 1;
        int valoff = off + len - 1;
        while (len > 0 && stroff >= 0) {
            int result = Hex.hex2int(str.charAt(stroff));
            if (--stroff >= 0) {
                result += Hex.hex2int(str.charAt(stroff)) << 4;
            }
            --stroff;
            val[valoff] = (byte)result;
            --valoff;
            --len;
        }
        while (len > 0) {
            val[valoff] = 0;
            --valoff;
            --len;
        }
    }

    private static int hex2int(char digit) {
        switch (digit) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return digit - 48;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return digit - 97 + 10;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return digit - 65 + 10;
            }
        }
        throw new IllegalArgumentException("Not a hexadecimal digit: '" + digit + "'");
    }
}

