/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.replica;

import edu.rit.mp.ShortBuf;
import edu.rit.mp.buf.ShortItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.reduction.ShortOp;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class ReplicatedShort
extends Number {
    private static final long serialVersionUID = 1L;
    private ShortOp myOp;
    private AtomicInteger myValue;
    private int myTag;
    private Comm myComm;
    private Receiver myReceiver;

    public ReplicatedShort(ShortOp op) {
        this(op, 0, 0, Comm.world());
    }

    public ReplicatedShort(ShortOp op, short initialValue) {
        this(op, initialValue, 0, Comm.world());
    }

    public ReplicatedShort(ShortOp op, short initialValue, int tag) {
        this(op, initialValue, tag, Comm.world());
    }

    public ReplicatedShort(ShortOp op, short initialValue, int tag, Comm comm) {
        if (op == null) {
            throw new NullPointerException("ReplicatedShort(): op is null");
        }
        if (comm == null) {
            throw new NullPointerException("ReplicatedShort(): comm is null");
        }
        this.myOp = op;
        this.myValue = new AtomicInteger(initialValue);
        this.myTag = tag;
        this.myComm = comm;
        this.myReceiver = new Receiver(this);
        this.myReceiver.setDaemon(true);
        this.myReceiver.start();
    }

    public short get() {
        return (short)this.myValue.get();
    }

    public short reduce(short value) throws IOException {
        short newvalue;
        short oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = (short)this.myValue.get(), newvalue = this.myOp.op(oldvalue, value))) {
        }
        if (newvalue != oldvalue) {
            this.myComm.floodSend(this.myTag, ShortBuf.buffer(newvalue));
        }
        return newvalue;
    }

    public String toString() {
        return Short.toString(this.get());
    }

    @Override
    public int intValue() {
        return this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    private class Receiver
    extends Thread {
        final /* synthetic */ ReplicatedShort this$0;

        private Receiver(ReplicatedShort replicatedShort) {
            ReplicatedShort replicatedShort2 = replicatedShort;
            Objects.requireNonNull(replicatedShort2);
            this.this$0 = replicatedShort2;
        }

        @Override
        public void run() {
            ShortItemBuf buf = ShortBuf.buffer();
            try {
                while (true) {
                    short newvalue;
                    short oldvalue;
                    this.this$0.myComm.floodReceive(this.this$0.myTag, buf);
                    while (!this.this$0.myValue.compareAndSet(oldvalue = (short)this.this$0.myValue.get(), newvalue = this.this$0.myOp.op(oldvalue, buf.item))) {
                    }
                }
            }
            catch (Throwable exc) {
                exc.printStackTrace(System.err);
                return;
            }
        }
    }
}

