/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.replica;

import edu.rit.mp.ObjectBuf;
import edu.rit.mp.buf.ObjectItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.reduction.ObjectOp;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class ReplicatedObject<T> {
    private ObjectOp<T> myOp;
    private AtomicReference<T> myValue;
    private int myTag;
    private Comm myComm;
    private Receiver myReceiver;

    public ReplicatedObject(ObjectOp<T> op) {
        this(op, null, 0, Comm.world());
    }

    public ReplicatedObject(ObjectOp<T> op, T initialValue) {
        this(op, initialValue, 0, Comm.world());
    }

    public ReplicatedObject(ObjectOp<T> op, T initialValue, int tag) {
        this(op, initialValue, tag, Comm.world());
    }

    public ReplicatedObject(ObjectOp<T> op, T initialValue, int tag, Comm comm) {
        if (op == null) {
            throw new NullPointerException("ReplicatedObject(): op is null");
        }
        if (comm == null) {
            throw new NullPointerException("ReplicatedObject(): comm is null");
        }
        this.myOp = op;
        this.myValue = new AtomicReference<T>(initialValue);
        this.myTag = tag;
        this.myComm = comm;
        this.myReceiver = new Receiver(this);
        this.myReceiver.setDaemon(true);
        this.myReceiver.start();
    }

    public T get() {
        return this.myValue.get();
    }

    public T reduce(T value) throws IOException {
        T newvalue;
        T oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = this.myValue.get(), newvalue = this.myOp.op(oldvalue, value))) {
        }
        if (newvalue != oldvalue) {
            this.myComm.floodSend(this.myTag, ObjectBuf.buffer(newvalue));
        }
        return newvalue;
    }

    public String toString() {
        return this.myValue.toString();
    }

    private class Receiver
    extends Thread {
        final /* synthetic */ ReplicatedObject this$0;

        private Receiver(ReplicatedObject replicatedObject) {
            ReplicatedObject replicatedObject2 = replicatedObject;
            Objects.requireNonNull(replicatedObject2);
            this.this$0 = replicatedObject2;
        }

        @Override
        public void run() {
            ObjectItemBuf buf = ObjectBuf.buffer();
            try {
                while (true) {
                    Object newvalue;
                    Object oldvalue;
                    this.this$0.myComm.floodReceive(this.this$0.myTag, buf);
                    while (!this.this$0.myValue.compareAndSet(oldvalue = this.this$0.myValue.get(), newvalue = this.this$0.myOp.op(oldvalue, buf.item))) {
                    }
                }
            }
            catch (Throwable exc) {
                exc.printStackTrace(System.err);
                return;
            }
        }
    }
}

