/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.replica;

import edu.rit.mp.LongBuf;
import edu.rit.mp.buf.LongItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.reduction.LongOp;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class ReplicatedLong
extends Number {
    private static final long serialVersionUID = 1L;
    private LongOp myOp;
    private AtomicLong myValue;
    private int myTag;
    private Comm myComm;
    private Receiver myReceiver;

    public ReplicatedLong(LongOp op) {
        this(op, 0L, 0, Comm.world());
    }

    public ReplicatedLong(LongOp op, long initialValue) {
        this(op, initialValue, 0, Comm.world());
    }

    public ReplicatedLong(LongOp op, long initialValue, int tag) {
        this(op, initialValue, tag, Comm.world());
    }

    public ReplicatedLong(LongOp op, long initialValue, int tag, Comm comm) {
        if (op == null) {
            throw new NullPointerException("ReplicatedLong(): op is null");
        }
        if (comm == null) {
            throw new NullPointerException("ReplicatedLong(): comm is null");
        }
        this.myOp = op;
        this.myValue = new AtomicLong(initialValue);
        this.myTag = tag;
        this.myComm = comm;
        this.myReceiver = new Receiver(this);
        this.myReceiver.setDaemon(true);
        this.myReceiver.start();
    }

    public long get() {
        return this.myValue.get();
    }

    public long reduce(long value) throws IOException {
        long newvalue;
        long oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = this.myValue.get(), newvalue = this.myOp.op(oldvalue, value))) {
        }
        if (newvalue != oldvalue) {
            this.myComm.floodSend(this.myTag, LongBuf.buffer(newvalue));
        }
        return newvalue;
    }

    public String toString() {
        return Long.toString(this.get());
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    private class Receiver
    extends Thread {
        final /* synthetic */ ReplicatedLong this$0;

        private Receiver(ReplicatedLong replicatedLong) {
            ReplicatedLong replicatedLong2 = replicatedLong;
            Objects.requireNonNull(replicatedLong2);
            this.this$0 = replicatedLong2;
        }

        @Override
        public void run() {
            LongItemBuf buf = LongBuf.buffer();
            try {
                while (true) {
                    long newvalue;
                    long oldvalue;
                    this.this$0.myComm.floodReceive(this.this$0.myTag, buf);
                    while (!this.this$0.myValue.compareAndSet(oldvalue = this.this$0.myValue.get(), newvalue = this.this$0.myOp.op(oldvalue, buf.item))) {
                    }
                }
            }
            catch (Throwable exc) {
                exc.printStackTrace(System.err);
                return;
            }
        }
    }
}

