/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.replica;

import edu.rit.mp.FloatBuf;
import edu.rit.mp.buf.FloatItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.reduction.FloatOp;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class ReplicatedFloat
extends Number {
    private final FloatOp myOp;
    private final AtomicInteger myValue;
    private final int myTag;
    private final Comm myComm;
    private final Receiver myReceiver;

    public ReplicatedFloat(FloatOp op) {
        this(op, 0.0f, 0, Comm.world());
    }

    public ReplicatedFloat(FloatOp op, float initialValue) {
        this(op, initialValue, 0, Comm.world());
    }

    public ReplicatedFloat(FloatOp op, float initialValue, int tag) {
        this(op, initialValue, tag, Comm.world());
    }

    public ReplicatedFloat(FloatOp op, float initialValue, int tag, Comm comm) {
        if (op == null) {
            throw new NullPointerException("ReplicatedFloat(): op is null");
        }
        if (comm == null) {
            throw new NullPointerException("ReplicatedFloat(): comm is null");
        }
        this.myOp = op;
        this.myValue = new AtomicInteger(Float.floatToIntBits(initialValue));
        this.myTag = tag;
        this.myComm = comm;
        this.myReceiver = new Receiver(this);
        this.myReceiver.setDaemon(true);
        this.myReceiver.start();
    }

    public float get() {
        return Float.intBitsToFloat(this.myValue.get());
    }

    public float reduce(float value) throws IOException {
        float oldvalue;
        float newvalue;
        int newint;
        int oldint;
        while (!this.myValue.compareAndSet(oldint = this.myValue.get(), newint = Float.floatToIntBits(newvalue = this.myOp.op(oldvalue = Float.intBitsToFloat(oldint), value)))) {
        }
        if (newvalue != oldvalue) {
            this.myComm.floodSend(this.myTag, FloatBuf.buffer(newvalue));
        }
        return newvalue;
    }

    public String toString() {
        return Float.toString(this.get());
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return (long)this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    private class Receiver
    extends Thread {
        final /* synthetic */ ReplicatedFloat this$0;

        private Receiver(ReplicatedFloat replicatedFloat) {
            ReplicatedFloat replicatedFloat2 = replicatedFloat;
            Objects.requireNonNull(replicatedFloat2);
            this.this$0 = replicatedFloat2;
        }

        @Override
        public void run() {
            FloatItemBuf buf = FloatBuf.buffer();
            try {
                while (true) {
                    float oldvalue;
                    float newvalue;
                    int newint;
                    int oldint;
                    this.this$0.myComm.floodReceive(this.this$0.myTag, buf);
                    while (!this.this$0.myValue.compareAndSet(oldint = this.this$0.myValue.get(), newint = Float.floatToIntBits(newvalue = this.this$0.myOp.op(oldvalue = Float.intBitsToFloat(oldint), buf.item)))) {
                    }
                }
            }
            catch (Throwable exc) {
                exc.printStackTrace(System.err);
                return;
            }
        }
    }
}

