/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.replica;

import edu.rit.mp.ByteBuf;
import edu.rit.mp.buf.ByteItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.reduction.ByteOp;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class ReplicatedByte
extends Number {
    private static final long serialVersionUID = 1L;
    private ByteOp myOp;
    private AtomicInteger myValue;
    private int myTag;
    private Comm myComm;
    private Receiver myReceiver;

    public ReplicatedByte(ByteOp op) {
        this(op, 0, 0, Comm.world());
    }

    public ReplicatedByte(ByteOp op, byte initialValue) {
        this(op, initialValue, 0, Comm.world());
    }

    public ReplicatedByte(ByteOp op, byte initialValue, int tag) {
        this(op, initialValue, tag, Comm.world());
    }

    public ReplicatedByte(ByteOp op, byte initialValue, int tag, Comm comm) {
        if (op == null) {
            throw new NullPointerException("ReplicatedByte(): op is null");
        }
        if (comm == null) {
            throw new NullPointerException("ReplicatedByte(): comm is null");
        }
        this.myOp = op;
        this.myValue = new AtomicInteger(initialValue);
        this.myTag = tag;
        this.myComm = comm;
        this.myReceiver = new Receiver(this);
        this.myReceiver.setDaemon(true);
        this.myReceiver.start();
    }

    public byte get() {
        return (byte)this.myValue.get();
    }

    public byte reduce(byte value) throws IOException {
        byte newvalue;
        byte oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = (byte)this.myValue.get(), newvalue = this.myOp.op(oldvalue, value))) {
        }
        if (newvalue != oldvalue) {
            this.myComm.floodSend(this.myTag, ByteBuf.buffer(newvalue));
        }
        return newvalue;
    }

    public String toString() {
        return Byte.toString(this.get());
    }

    @Override
    public int intValue() {
        return this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    private class Receiver
    extends Thread {
        final /* synthetic */ ReplicatedByte this$0;

        private Receiver(ReplicatedByte replicatedByte) {
            ReplicatedByte replicatedByte2 = replicatedByte;
            Objects.requireNonNull(replicatedByte2);
            this.this$0 = replicatedByte2;
        }

        @Override
        public void run() {
            ByteItemBuf buf = ByteBuf.buffer();
            try {
                while (true) {
                    byte newvalue;
                    byte oldvalue;
                    this.this$0.myComm.floodReceive(this.this$0.myTag, buf);
                    while (!this.this$0.myValue.compareAndSet(oldvalue = (byte)this.this$0.myValue.get(), newvalue = this.this$0.myOp.op(oldvalue, buf.item))) {
                    }
                }
            }
            catch (Throwable exc) {
                exc.printStackTrace(System.err);
                return;
            }
        }
    }
}

