/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.ObjectOp;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class SharedObjectArray<T> {
    private AtomicReferenceArray<T> myArray;

    public SharedObjectArray(int len) {
        this.myArray = new AtomicReferenceArray(len);
    }

    public SharedObjectArray(T[] array) {
        this.myArray = new AtomicReferenceArray<T>(array);
    }

    public int length() {
        return this.myArray.length();
    }

    public T get(int i) {
        return this.myArray.get(i);
    }

    public void set(int i, T value) {
        this.myArray.set(i, value);
    }

    public T getAndSet(int i, T value) {
        return this.myArray.getAndSet(i, value);
    }

    public boolean compareAndSet(int i, T expect, T update) {
        return this.myArray.compareAndSet(i, expect, update);
    }

    public boolean weakCompareAndSet(int i, T expect, T update) {
        return this.myArray.weakCompareAndSet(i, expect, update);
    }

    public T reduce(int i, T value, ObjectOp<T> op) {
        T newvalue;
        T oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue = this.myArray.get(i), newvalue = op.op(oldvalue, value))) {
        }
        return newvalue;
    }

    public void reduce(T[] src, ObjectOp<T> op) {
        this.reduce(0, src, 0, this.myArray.length(), op);
    }

    public void reduce(int dstoff, T[] src, int srcoff, int len, ObjectOp<T> op) {
        if (len < 0 || dstoff < 0 || dstoff + len > this.myArray.length() || srcoff < 0 || srcoff + len > src.length) {
            throw new IndexOutOfBoundsException();
        }
        while (len > 0) {
            T newvalue;
            T oldvalue;
            while (!this.myArray.compareAndSet(dstoff, oldvalue = this.myArray.get(dstoff), newvalue = op.op(oldvalue, src[srcoff]))) {
            }
            ++dstoff;
            ++srcoff;
            --len;
        }
    }

    public String toString() {
        return this.myArray.toString();
    }
}

