/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.ObjectOp;
import java.util.concurrent.atomic.AtomicReference;

public class SharedObject<T> {
    private AtomicReference<T> myValue;

    public SharedObject() {
        this.myValue = new AtomicReference();
    }

    public SharedObject(T initialValue) {
        this.myValue = new AtomicReference<T>(initialValue);
    }

    public T get() {
        return this.myValue.get();
    }

    public void set(T value) {
        this.myValue.set(value);
    }

    public T getAndSet(T value) {
        return this.myValue.getAndSet(value);
    }

    public boolean compareAndSet(T expect, T update) {
        return this.myValue.compareAndSet(expect, update);
    }

    public boolean weakCompareAndSet(T expect, T update) {
        return this.myValue.weakCompareAndSet(expect, update);
    }

    public T reduce(T value, ObjectOp<T> op) {
        T newvalue;
        T oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = this.myValue.get(), newvalue = op.op(oldvalue, value))) {
        }
        return newvalue;
    }

    public String toString() {
        return this.myValue.toString();
    }
}

