/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.LongOp;
import java.util.concurrent.atomic.AtomicLongArray;

public class SharedLongArray {
    private AtomicLongArray myArray;

    public SharedLongArray(int len) {
        this.myArray = new AtomicLongArray(len);
    }

    public SharedLongArray(long[] array) {
        this.myArray = new AtomicLongArray(array);
    }

    public int length() {
        return this.myArray.length();
    }

    public long get(int i) {
        return this.myArray.get(i);
    }

    public void set(int i, long value) {
        this.myArray.set(i, value);
    }

    public long getAndSet(int i, long value) {
        return this.myArray.getAndSet(i, value);
    }

    public boolean compareAndSet(int i, long expect, long update) {
        return this.myArray.compareAndSet(i, expect, update);
    }

    public boolean weakCompareAndSet(int i, long expect, long update) {
        return this.myArray.weakCompareAndSet(i, expect, update);
    }

    public long getAndIncrement(int i) {
        return this.myArray.getAndIncrement(i);
    }

    public long getAndDecrement(int i) {
        return this.myArray.getAndDecrement(i);
    }

    public long getAndAdd(int i, long value) {
        return this.myArray.getAndAdd(i, value);
    }

    public long incrementAndGet(int i) {
        return this.myArray.incrementAndGet(i);
    }

    public long decrementAndGet(int i) {
        return this.myArray.decrementAndGet(i);
    }

    public long addAndGet(int i, long value) {
        return this.myArray.addAndGet(i, value);
    }

    public long reduce(int i, long value, LongOp op) {
        long newvalue;
        long oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue = this.myArray.get(i), newvalue = op.op(oldvalue, value))) {
        }
        return newvalue;
    }

    public void reduce(long[] src, LongOp op) {
        this.reduce(0, src, 0, this.myArray.length(), op);
    }

    public void reduce(int dstoff, long[] src, int srcoff, int len, LongOp op) {
        if (len < 0 || dstoff < 0 || dstoff + len > this.myArray.length() || srcoff < 0 || srcoff + len > src.length) {
            throw new IndexOutOfBoundsException();
        }
        while (len > 0) {
            long newvalue;
            long oldvalue;
            while (!this.myArray.compareAndSet(dstoff, oldvalue = this.myArray.get(dstoff), newvalue = op.op(oldvalue, src[srcoff]))) {
            }
            ++dstoff;
            ++srcoff;
            --len;
        }
    }

    public String toString() {
        return this.myArray.toString();
    }
}

