/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.LongOp;
import java.util.concurrent.atomic.AtomicLong;

public class SharedLong
extends Number {
    private static final long serialVersionUID = 1L;
    private AtomicLong myValue;

    public SharedLong() {
        this.myValue = new AtomicLong();
    }

    public SharedLong(long initialValue) {
        this.myValue = new AtomicLong(initialValue);
    }

    public long get() {
        return this.myValue.get();
    }

    public void set(long value) {
        this.myValue.set(value);
    }

    public long getAndSet(long value) {
        return this.myValue.getAndSet(value);
    }

    public boolean compareAndSet(long expect, long update) {
        return this.myValue.compareAndSet(expect, update);
    }

    public boolean weakCompareAndSet(long expect, long update) {
        return this.myValue.weakCompareAndSet(expect, update);
    }

    public long getAndIncrement() {
        return this.myValue.getAndIncrement();
    }

    public long getAndDecrement() {
        return this.myValue.getAndDecrement();
    }

    public long getAndAdd(long value) {
        return this.myValue.getAndAdd(value);
    }

    public long incrementAndGet() {
        return this.myValue.incrementAndGet();
    }

    public long decrementAndGet() {
        return this.myValue.decrementAndGet();
    }

    public long addAndGet(long value) {
        return this.myValue.addAndGet(value);
    }

    public long reduce(long value, LongOp op) {
        long newvalue;
        long oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = this.myValue.get(), newvalue = op.op(oldvalue, value))) {
        }
        return newvalue;
    }

    public String toString() {
        return Long.toString(this.get());
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }
}

