/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.FloatOp;
import java.util.concurrent.atomic.AtomicInteger;

public class SharedFloat
extends Number {
    private static final long serialVersionUID = 1L;
    private AtomicInteger myValue;

    public SharedFloat() {
        this.myValue = new AtomicInteger(Float.floatToIntBits(0.0f));
    }

    public SharedFloat(float initialValue) {
        this.myValue = new AtomicInteger(Float.floatToIntBits(initialValue));
    }

    public float get() {
        return Float.intBitsToFloat(this.myValue.get());
    }

    public void set(float value) {
        this.myValue.set(Float.floatToIntBits(value));
    }

    public float getAndSet(float value) {
        return Float.intBitsToFloat(this.myValue.getAndSet(Float.floatToIntBits(value)));
    }

    public boolean compareAndSet(float expect, float update) {
        return this.myValue.compareAndSet(Float.floatToIntBits(expect), Float.floatToIntBits(update));
    }

    public boolean weakCompareAndSet(float expect, float update) {
        return this.myValue.weakCompareAndSet(Float.floatToIntBits(expect), Float.floatToIntBits(update));
    }

    public float getAndIncrement() {
        float oldvalue;
        float newvalue;
        int newvalueInt;
        int oldvalueInt;
        while (!this.myValue.compareAndSet(oldvalueInt = this.myValue.get(), newvalueInt = Float.floatToIntBits(newvalue = (oldvalue = Float.intBitsToFloat(oldvalueInt)) + 1.0f))) {
        }
        return oldvalue;
    }

    public float getAndDecrement() {
        float oldvalue;
        float newvalue;
        int newvalueInt;
        int oldvalueInt;
        while (!this.myValue.compareAndSet(oldvalueInt = this.myValue.get(), newvalueInt = Float.floatToIntBits(newvalue = (oldvalue = Float.intBitsToFloat(oldvalueInt)) - 1.0f))) {
        }
        return oldvalue;
    }

    public float getAndAdd(float value) {
        float oldvalue;
        float newvalue;
        int newvalueInt;
        int oldvalueInt;
        while (!this.myValue.compareAndSet(oldvalueInt = this.myValue.get(), newvalueInt = Float.floatToIntBits(newvalue = (oldvalue = Float.intBitsToFloat(oldvalueInt)) + value))) {
        }
        return oldvalue;
    }

    public float incrementAndGet() {
        float oldvalue;
        float newvalue;
        int newvalueInt;
        int oldvalueInt;
        while (!this.myValue.compareAndSet(oldvalueInt = this.myValue.get(), newvalueInt = Float.floatToIntBits(newvalue = (oldvalue = Float.intBitsToFloat(oldvalueInt)) + 1.0f))) {
        }
        return newvalue;
    }

    public float decrementAndGet() {
        float oldvalue;
        float newvalue;
        int newvalueInt;
        int oldvalueInt;
        while (!this.myValue.compareAndSet(oldvalueInt = this.myValue.get(), newvalueInt = Float.floatToIntBits(newvalue = (oldvalue = Float.intBitsToFloat(oldvalueInt)) - 1.0f))) {
        }
        return newvalue;
    }

    public float addAndGet(float value) {
        float oldvalue;
        float newvalue;
        int newvalueInt;
        int oldvalueInt;
        while (!this.myValue.compareAndSet(oldvalueInt = this.myValue.get(), newvalueInt = Float.floatToIntBits(newvalue = (oldvalue = Float.intBitsToFloat(oldvalueInt)) + value))) {
        }
        return newvalue;
    }

    public float reduce(float value, FloatOp op) {
        float oldvalue;
        float newvalue;
        int newvalueInt;
        int oldvalueInt;
        while (!this.myValue.compareAndSet(oldvalueInt = this.myValue.get(), newvalueInt = Float.floatToIntBits(newvalue = op.op(oldvalue = Float.intBitsToFloat(oldvalueInt), value)))) {
        }
        return newvalue;
    }

    public String toString() {
        return Float.toString(this.get());
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return (long)this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }
}

