/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.DoubleOp;
import java.util.concurrent.atomic.AtomicLongArray;

public class SharedDoubleArray {
    private AtomicLongArray myArray;

    public SharedDoubleArray(int len) {
        this.myArray = new AtomicLongArray(len);
    }

    public SharedDoubleArray(double[] array) {
        int n = array.length;
        long[] longarray = new long[n];
        for (int i = 0; i < n; ++i) {
            longarray[i] = Double.doubleToLongBits(array[i]);
        }
        this.myArray = new AtomicLongArray(longarray);
    }

    public int length() {
        return this.myArray.length();
    }

    public double get(int i) {
        return Double.longBitsToDouble(this.myArray.get(i));
    }

    public void set(int i, double value) {
        this.myArray.set(i, Double.doubleToLongBits(value));
    }

    public double getAndSet(int i, double value) {
        return Double.longBitsToDouble(this.myArray.getAndSet(i, Double.doubleToLongBits(value)));
    }

    public boolean compareAndSet(int i, double expect, double update) {
        return this.myArray.compareAndSet(i, Double.doubleToLongBits(expect), Double.doubleToLongBits(update));
    }

    public boolean weakCompareAndSet(int i, double expect, double update) {
        return this.myArray.weakCompareAndSet(i, Double.doubleToLongBits(expect), Double.doubleToLongBits(update));
    }

    public double getAndIncrement(int i) {
        double oldvalue;
        double newvalue;
        long newvalueLong;
        long oldvalueLong;
        while (!this.myArray.compareAndSet(i, oldvalueLong = this.myArray.get(i), newvalueLong = Double.doubleToLongBits(newvalue = (oldvalue = Double.longBitsToDouble(oldvalueLong)) + 1.0))) {
        }
        return oldvalue;
    }

    public double getAndDecrement(int i) {
        double oldvalue;
        double newvalue;
        long newvalueLong;
        long oldvalueLong;
        while (!this.myArray.compareAndSet(i, oldvalueLong = this.myArray.get(i), newvalueLong = Double.doubleToLongBits(newvalue = (oldvalue = Double.longBitsToDouble(oldvalueLong)) - 1.0))) {
        }
        return oldvalue;
    }

    public double getAndAdd(int i, double value) {
        double oldvalue;
        double newvalue;
        long newvalueLong;
        long oldvalueLong;
        while (!this.myArray.compareAndSet(i, oldvalueLong = this.myArray.get(i), newvalueLong = Double.doubleToLongBits(newvalue = (oldvalue = Double.longBitsToDouble(oldvalueLong)) + value))) {
        }
        return oldvalue;
    }

    public double incrementAndGet(int i) {
        double oldvalue;
        double newvalue;
        long newvalueLong;
        long oldvalueLong;
        while (!this.myArray.compareAndSet(i, oldvalueLong = this.myArray.get(i), newvalueLong = Double.doubleToLongBits(newvalue = (oldvalue = Double.longBitsToDouble(oldvalueLong)) + 1.0))) {
        }
        return newvalue;
    }

    public double decrementAndGet(int i) {
        double oldvalue;
        double newvalue;
        long newvalueLong;
        long oldvalueLong;
        while (!this.myArray.compareAndSet(i, oldvalueLong = this.myArray.get(i), newvalueLong = Double.doubleToLongBits(newvalue = (oldvalue = Double.longBitsToDouble(oldvalueLong)) - 1.0))) {
        }
        return newvalue;
    }

    public double addAndGet(int i, double value) {
        double oldvalue;
        double newvalue;
        long newvalueLong;
        long oldvalueLong;
        while (!this.myArray.compareAndSet(i, oldvalueLong = this.myArray.get(i), newvalueLong = Double.doubleToLongBits(newvalue = (oldvalue = Double.longBitsToDouble(oldvalueLong)) + value))) {
        }
        return newvalue;
    }

    public double reduce(int i, double value, DoubleOp op) {
        double oldvalue;
        double newvalue;
        long newvalueLong;
        long oldvalueLong;
        while (!this.myArray.compareAndSet(i, oldvalueLong = this.myArray.get(i), newvalueLong = Double.doubleToLongBits(newvalue = op.op(oldvalue = Double.longBitsToDouble(oldvalueLong), value)))) {
        }
        return newvalue;
    }

    public void reduce(double[] src, DoubleOp op) {
        this.reduce(0, src, 0, this.myArray.length(), op);
    }

    public void reduce(int dstoff, double[] src, int srcoff, int len, DoubleOp op) {
        if (len < 0 || dstoff < 0 || dstoff + len > this.myArray.length() || srcoff < 0 || srcoff + len > src.length) {
            throw new IndexOutOfBoundsException();
        }
        while (len > 0) {
            double oldvalue;
            double newvalue;
            long newvalueLong;
            long oldvalueLong;
            while (!this.myArray.compareAndSet(dstoff, oldvalueLong = this.myArray.get(dstoff), newvalueLong = Double.doubleToLongBits(newvalue = op.op(oldvalue = Double.longBitsToDouble(oldvalueLong), src[srcoff])))) {
            }
            ++dstoff;
            ++srcoff;
            --len;
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('[');
        int n = this.myArray.length();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(this.get(i));
        }
        b.append(']');
        return b.toString();
    }
}

