/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.CharacterOp;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class SharedCharacterArray {
    private AtomicIntegerArray myArray;

    public SharedCharacterArray(int len) {
        this.myArray = new AtomicIntegerArray(len);
    }

    public SharedCharacterArray(char[] array) {
        int n = array.length;
        int[] intarray = new int[n];
        for (int i = 0; i < n; ++i) {
            intarray[i] = array[i];
        }
        this.myArray = new AtomicIntegerArray(intarray);
    }

    public int length() {
        return this.myArray.length();
    }

    public char get(int i) {
        return (char)this.myArray.get(i);
    }

    public void set(int i, char value) {
        this.myArray.set(i, value);
    }

    public char getAndSet(int i, char value) {
        return (char)this.myArray.getAndSet(i, value);
    }

    public boolean compareAndSet(int i, char expect, char update) {
        return this.myArray.compareAndSet(i, expect, update);
    }

    public boolean weakCompareAndSet(int i, char expect, char update) {
        return this.myArray.weakCompareAndSet(i, expect, update);
    }

    public char getAndIncrement(int i) {
        char newvalue;
        char oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue = (char)this.myArray.get(i), newvalue = (char)(oldvalue + '\u0001'))) {
        }
        return oldvalue;
    }

    public char getAndDecrement(int i) {
        char newvalue;
        char oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue = (char)this.myArray.get(i), newvalue = (char)(oldvalue - '\u0001'))) {
        }
        return oldvalue;
    }

    public char getAndAdd(int i, char value) {
        char newvalue;
        char oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue = (char)this.myArray.get(i), newvalue = (char)(oldvalue + value))) {
        }
        return oldvalue;
    }

    public char incrementAndGet(int i) {
        char newvalue;
        char oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue = (char)this.myArray.get(i), newvalue = (char)(oldvalue + '\u0001'))) {
        }
        return newvalue;
    }

    public char decrementAndGet(int i) {
        char newvalue;
        char oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue = (char)this.myArray.get(i), newvalue = (char)(oldvalue - '\u0001'))) {
        }
        return newvalue;
    }

    public char addAndGet(int i, char value) {
        char newvalue;
        char oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue = (char)this.myArray.get(i), newvalue = (char)(oldvalue + value))) {
        }
        return newvalue;
    }

    public char reduce(int i, char value, CharacterOp op) {
        char newvalue;
        char oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue = (char)this.myArray.get(i), newvalue = op.op(oldvalue, value))) {
        }
        return newvalue;
    }

    public void reduce(char[] src, CharacterOp op) {
        this.reduce(0, src, 0, this.myArray.length(), op);
    }

    public void reduce(int dstoff, char[] src, int srcoff, int len, CharacterOp op) {
        if (len < 0 || dstoff < 0 || dstoff + len > this.myArray.length() || srcoff < 0 || srcoff + len > src.length) {
            throw new IndexOutOfBoundsException();
        }
        while (len > 0) {
            char newvalue;
            char oldvalue;
            while (!this.myArray.compareAndSet(dstoff, oldvalue = (char)this.myArray.get(dstoff), newvalue = op.op(oldvalue, src[srcoff]))) {
            }
            ++dstoff;
            ++srcoff;
            --len;
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('[');
        int n = this.myArray.length();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(this.get(i));
        }
        b.append(']');
        return b.toString();
    }
}

