/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.ByteOp;
import java.util.concurrent.atomic.AtomicInteger;

public class SharedByte
extends Number {
    private static final long serialVersionUID = 1L;
    private AtomicInteger myValue;

    public SharedByte() {
        this.myValue = new AtomicInteger();
    }

    public SharedByte(byte initialValue) {
        this.myValue = new AtomicInteger(initialValue);
    }

    public byte get() {
        return (byte)this.myValue.get();
    }

    public void set(byte value) {
        this.myValue.set(value);
    }

    public byte getAndSet(byte value) {
        return (byte)this.myValue.getAndSet(value);
    }

    public boolean compareAndSet(byte expect, byte update) {
        return this.myValue.compareAndSet(expect, update);
    }

    public boolean weakCompareAndSet(byte expect, byte update) {
        return this.myValue.weakCompareAndSet(expect, update);
    }

    public byte getAndIncrement() {
        byte newvalue;
        byte oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = (byte)this.myValue.get(), newvalue = (byte)(oldvalue + 1))) {
        }
        return oldvalue;
    }

    public byte getAndDecrement() {
        byte newvalue;
        byte oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = (byte)this.myValue.get(), newvalue = (byte)(oldvalue - 1))) {
        }
        return oldvalue;
    }

    public byte getAndAdd(byte value) {
        byte newvalue;
        byte oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = (byte)this.myValue.get(), newvalue = (byte)(oldvalue + value))) {
        }
        return oldvalue;
    }

    public byte incrementAndGet() {
        byte newvalue;
        byte oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = (byte)this.myValue.get(), newvalue = (byte)(oldvalue + 1))) {
        }
        return newvalue;
    }

    public byte decrementAndGet() {
        byte newvalue;
        byte oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = (byte)this.myValue.get(), newvalue = (byte)(oldvalue - 1))) {
        }
        return newvalue;
    }

    public byte addAndGet(byte value) {
        byte newvalue;
        byte oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = (byte)this.myValue.get(), newvalue = (byte)(oldvalue + value))) {
        }
        return newvalue;
    }

    public byte reduce(byte value, ByteOp op) {
        byte newvalue;
        byte oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = (byte)this.myValue.get(), newvalue = op.op(oldvalue, value))) {
        }
        return newvalue;
    }

    public String toString() {
        return Integer.toString(this.get());
    }

    @Override
    public int intValue() {
        return this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }
}

