/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.BooleanOp;
import java.util.concurrent.atomic.AtomicBoolean;

public class SharedBoolean {
    private AtomicBoolean myValue;

    public SharedBoolean() {
        this.myValue = new AtomicBoolean();
    }

    public SharedBoolean(boolean initialValue) {
        this.myValue = new AtomicBoolean(initialValue);
    }

    public boolean get() {
        return this.myValue.get();
    }

    public void set(boolean value) {
        this.myValue.set(value);
    }

    public boolean getAndSet(boolean value) {
        return this.myValue.getAndSet(value);
    }

    public boolean compareAndSet(boolean expect, boolean update) {
        return this.myValue.compareAndSet(expect, update);
    }

    public boolean weakCompareAndSet(boolean expect, boolean update) {
        return this.myValue.weakCompareAndSet(expect, update);
    }

    public boolean reduce(boolean value, BooleanOp op) {
        boolean newvalue;
        boolean oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = this.myValue.get(), newvalue = op.op(oldvalue, value))) {
        }
        return newvalue;
    }

    public String toString() {
        return Boolean.toString(this.get());
    }
}

