/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.job;

import edu.rit.io.Stdio;
import edu.rit.pj.job.Stderr;
import edu.rit.pj.job.Stdin;
import edu.rit.pj.job.Stdout;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class Job
implements Runnable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private int myJobNumber;
    private String myDescription;
    private String myMainClassName;
    private final ArrayList<String> myArguments = new ArrayList();
    private Stdin myStdinRedirection = Stdin.NONE;
    private Stdout myStdoutRedirection = Stdout.NONE;
    private Stderr myStderrRedirection = Stderr.NONE;
    private File myStdinFile = null;
    private File myStdoutFile = null;
    private File myStderrFile = null;

    public Job() {
    }

    public Job(int theJobNumber, String theDescription, String theMainClassName) {
        if (theMainClassName == null) {
            throw new NullPointerException("Job(): Main class name is null");
        }
        this.myJobNumber = theJobNumber;
        this.myDescription = theDescription;
        this.myMainClassName = theMainClassName;
    }

    public int getJobNumber() {
        return this.myJobNumber;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void addArgument(String arg) {
        if (arg == null) {
            throw new NullPointerException("Job.addArgument(): Argument string is null");
        }
        this.myArguments.add(arg);
    }

    public void stdinFromFile(File file) {
        if (file == null) {
            throw new NullPointerException("Job.stdinFromFile(): File is null");
        }
        this.myStdinRedirection = Stdin.FILE;
        this.myStdinFile = file;
    }

    public void stdoutToFile(File file) {
        if (file == null) {
            throw new NullPointerException("Job.stdoutToFile(): File is null");
        }
        this.myStdoutRedirection = Stdout.FILE;
        this.myStdoutFile = file;
    }

    public void stdoutAppendToFile(File file) {
        if (file == null) {
            throw new NullPointerException("Job.stdoutAppendToFile(): File is null");
        }
        this.myStdoutRedirection = Stdout.FILE_APPEND;
        this.myStdoutFile = file;
    }

    public void stderrToFile(File file) {
        if (file == null) {
            throw new NullPointerException("Job.stderrToFile(): File is null");
        }
        this.myStderrRedirection = Stderr.FILE;
        this.myStderrFile = file;
    }

    public void stderrAppendToFile(File file) {
        if (file == null) {
            throw new NullPointerException("Job.stderrAppendToFile(): File is null");
        }
        this.myStderrRedirection = Stderr.FILE_APPEND;
        this.myStderrFile = file;
    }

    public void stderrToStdout() {
        this.myStderrRedirection = Stderr.STDOUT;
        this.myStderrFile = null;
    }

    @Override
    public void run() {
        try {
            switch (this.myStdinRedirection) {
                case FILE: {
                    Stdio.in(new FileInputStream(this.myStdinFile));
                }
            }
            switch (this.myStdoutRedirection) {
                case FILE: {
                    Stdio.out(new PrintStream(new FileOutputStream(this.myStdoutFile, false), true));
                    break;
                }
                case FILE_APPEND: {
                    Stdio.out(new PrintStream(new FileOutputStream(this.myStdoutFile, true), true));
                }
            }
            switch (this.myStderrRedirection) {
                case FILE: {
                    Stdio.err(new PrintStream(new FileOutputStream(this.myStderrFile, false), true));
                    break;
                }
                case FILE_APPEND: {
                    Stdio.err(new PrintStream(new FileOutputStream(this.myStderrFile, true), true));
                    break;
                }
                case STDOUT: {
                    Stdio.err(Stdio.out());
                }
            }
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
        try {
            Class<?> mainClass = Class.forName(this.myMainClassName, true, Thread.currentThread().getContextClassLoader());
            Method mainMethod = mainClass.getMethod("main", String[].class);
            int modifiers = mainMethod.getModifiers();
            if (!Modifier.isStatic(mainMethod.getModifiers())) {
                throw new NoSuchMethodException("Job.run(): Class " + mainClass.getName() + " main() method is not static");
            }
            if (mainMethod.getReturnType() != Void.TYPE) {
                throw new NoSuchMethodException("Job.run(): Class " + mainClass.getName() + " main() method does not return void");
            }
            String[] args = this.myArguments.toArray(new String[0]);
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (Throwable exc) {
            exc.printStackTrace(Stdio.err());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.myJobNumber);
        out.writeUTF(this.myDescription);
        out.writeUTF(this.myMainClassName);
        out.writeInt(this.myArguments.size());
        for (String arg : this.myArguments) {
            out.writeUTF(arg);
        }
        out.writeObject((Object)this.myStdinRedirection);
        out.writeObject((Object)this.myStdoutRedirection);
        out.writeObject((Object)this.myStderrRedirection);
        out.writeObject(this.myStdinFile);
        out.writeObject(this.myStdoutFile);
        out.writeObject(this.myStderrFile);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.myJobNumber = in.readInt();
        this.myDescription = in.readUTF();
        this.myMainClassName = in.readUTF();
        this.myArguments.clear();
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            this.myArguments.add(in.readUTF());
        }
        this.myStdinRedirection = (Stdin)((Object)in.readObject());
        this.myStdoutRedirection = (Stdout)((Object)in.readObject());
        this.myStderrRedirection = (Stderr)((Object)in.readObject());
        this.myStdinFile = (File)in.readObject();
        this.myStdoutFile = (File)in.readObject();
        this.myStderrFile = (File)in.readObject();
    }
}

