/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.io;

import edu.rit.pj.cluster.JobBackend;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamFile {
    private File myFile;

    public StreamFile(File theFile) {
        if (theFile == null) {
            throw new NullPointerException("StreamFile(): theFile is null");
        }
        this.myFile = theFile;
    }

    public File getFile() {
        return this.myFile;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.getOutputStream(false);
    }

    public OutputStream getOutputStream(boolean append) throws IOException {
        JobBackend backend = JobBackend.getJobBackend();
        if (backend == null) {
            return new FileOutputStream(this.myFile, append);
        }
        return backend.getFileWriter().open(this.myFile, append);
    }

    public InputStream getInputStream() throws IOException {
        JobBackend backend = JobBackend.getJobBackend();
        if (backend == null) {
            return new FileInputStream(this.myFile);
        }
        return backend.getFileReader().open(this.myFile);
    }

    public boolean equals(Object obj) {
        return obj instanceof StreamFile && this.myFile.equals(((StreamFile)obj).myFile);
    }

    public int hashCode() {
        return this.myFile.hashCode();
    }

    public String toString() {
        return this.myFile.toString();
    }
}

