/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import java.util.HashMap;
import java.util.Map;

public class ResourceCache {
    private Map<String, ResourceInfo> myMap = new HashMap<String, ResourceInfo>();

    public synchronized boolean contains(String name) {
        ResourceInfo info = this.myMap.get(name);
        return info != null;
    }

    public synchronized boolean containsContent(String name) {
        ResourceInfo info = this.myMap.get(name);
        return info == null ? false : info.content != null;
    }

    public synchronized byte[] get(String name) throws InterruptedException {
        ResourceInfo info = this.myMap.get(name);
        while (info == null) {
            this.wait();
            info = this.myMap.get(name);
        }
        return info.content;
    }

    public synchronized byte[] getNoWait(String name) {
        ResourceInfo info = this.myMap.get(name);
        return info == null ? null : info.content;
    }

    public synchronized void put(String name, byte[] content) {
        this.myMap.put(name, new ResourceInfo(content));
        this.notifyAll();
    }

    public synchronized void remove(String name) {
        this.myMap.remove(name);
    }

    private static class ResourceInfo {
        public byte[] content;

        public ResourceInfo(byte[] content) {
            this.content = content;
        }
    }
}

