/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.pj.cluster.JobFrontendRef;
import edu.rit.pj.cluster.JobSchedulerRef;
import edu.rit.pj.cluster.Message;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class JobSchedulerMessage
extends Message
implements Externalizable {
    private static final long serialVersionUID = -7379945472003527741L;

    public JobSchedulerMessage() {
    }

    public JobSchedulerMessage(int theTag) {
        super(theTag);
    }

    public static JobSchedulerMessage backendFailed(JobFrontendRef theJobFrontend, String name) {
        return new BackendFailedMessage(theJobFrontend, name);
    }

    public static JobSchedulerMessage cancelJob(JobFrontendRef theJobFrontend, String errmsg) {
        return new CancelJobMessage(theJobFrontend, errmsg);
    }

    public static JobSchedulerMessage jobFinished(JobFrontendRef theJobFrontend) {
        return new JobFinishedMessage(theJobFrontend);
    }

    public static JobSchedulerMessage renewLease(JobFrontendRef theJobFrontend) {
        return new RenewLeaseMessage(theJobFrontend);
    }

    public static JobSchedulerMessage reportComment(JobFrontendRef theJobFrontend, int rank, String comment) {
        return new ReportCommentMessage(theJobFrontend, rank, comment);
    }

    public static JobSchedulerMessage requestJob(JobFrontendRef theJobFrontend, String username, int Nn, int Np, int Nt) {
        return new RequestJobMessage(theJobFrontend, username, Nn, Np, Nt);
    }

    public void invoke(JobSchedulerRef theJobScheduler, JobFrontendRef theJobFrontend) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
    }

    private static class BackendFailedMessage
    extends JobSchedulerMessage {
        private static final long serialVersionUID = 6495614788809259018L;
        private String name;

        public BackendFailedMessage() {
        }

        public BackendFailedMessage(JobFrontendRef theJobFrontend, String name) {
            super(2);
            this.name = name;
        }

        @Override
        public void invoke(JobSchedulerRef theJobScheduler, JobFrontendRef theJobFrontend) throws IOException {
            theJobScheduler.backendFailed(theJobFrontend, this.name);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.name);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.name = in.readUTF();
        }
    }

    private static class CancelJobMessage
    extends JobSchedulerMessage {
        private static final long serialVersionUID = 2902818757044365344L;
        private String errmsg;

        public CancelJobMessage() {
        }

        public CancelJobMessage(JobFrontendRef theJobFrontend, String errmsg) {
            super(2);
            this.errmsg = errmsg;
        }

        @Override
        public void invoke(JobSchedulerRef theJobScheduler, JobFrontendRef theJobFrontend) throws IOException {
            theJobScheduler.cancelJob(theJobFrontend, this.errmsg);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.errmsg);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.errmsg = in.readUTF();
        }
    }

    private static class JobFinishedMessage
    extends JobSchedulerMessage {
        private static final long serialVersionUID = -1179228962545666153L;

        public JobFinishedMessage() {
        }

        public JobFinishedMessage(JobFrontendRef theJobFrontend) {
            super(2);
        }

        @Override
        public void invoke(JobSchedulerRef theJobScheduler, JobFrontendRef theJobFrontend) throws IOException {
            theJobScheduler.jobFinished(theJobFrontend);
        }
    }

    private static class RenewLeaseMessage
    extends JobSchedulerMessage {
        private static final long serialVersionUID = 8547605668292095227L;

        public RenewLeaseMessage() {
        }

        public RenewLeaseMessage(JobFrontendRef theJobFrontend) {
            super(2);
        }

        @Override
        public void invoke(JobSchedulerRef theJobScheduler, JobFrontendRef theJobFrontend) throws IOException {
            theJobScheduler.renewLease(theJobFrontend);
        }
    }

    private static class ReportCommentMessage
    extends JobSchedulerMessage {
        private static final long serialVersionUID = -7431990305653172900L;
        private int rank;
        private String comment;

        public ReportCommentMessage() {
        }

        public ReportCommentMessage(JobFrontendRef theJobFrontend, int rank, String comment) {
            super(2);
            this.rank = rank;
            this.comment = comment == null ? "" : comment;
        }

        @Override
        public void invoke(JobSchedulerRef theJobScheduler, JobFrontendRef theJobFrontend) throws IOException {
            theJobScheduler.reportComment(theJobFrontend, this.rank, this.comment);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.rank);
            out.writeUTF(this.comment);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.rank = in.readInt();
            this.comment = in.readUTF();
        }
    }

    private static class RequestJobMessage
    extends JobSchedulerMessage {
        private static final long serialVersionUID = -6712799261136980645L;
        private String username;
        private int Nn;
        private int Np;
        private int Nt;

        public RequestJobMessage() {
        }

        public RequestJobMessage(JobFrontendRef theJobFrontend, String username, int Nn, int Np, int Nt) {
            super(2);
            this.username = username;
            this.Nn = Nn;
            this.Np = Np;
            this.Nt = Nt;
        }

        @Override
        public void invoke(JobSchedulerRef theJobScheduler, JobFrontendRef theJobFrontend) throws IOException {
            theJobScheduler.requestJob(theJobFrontend, this.username, this.Nn, this.Np, this.Nt);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.username);
            out.writeInt(this.Nn);
            out.writeInt(this.Np);
            out.writeInt(this.Nt);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.username = in.readUTF();
            this.Nn = in.readInt();
            this.Np = in.readInt();
            this.Nt = in.readInt();
        }
    }
}

