/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontendRef;
import edu.rit.pj.cluster.JobSchedulerRef;
import edu.rit.pj.cluster.Message;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetSocketAddress;

public abstract class JobFrontendMessage
extends Message
implements Externalizable {
    private static final long serialVersionUID = -6601793901631997673L;

    public JobFrontendMessage() {
    }

    public JobFrontendMessage(int theTag) {
        super(theTag);
    }

    public static JobFrontendMessage assignBackend(JobSchedulerRef theJobScheduler, String name, String host, String jvm, String classpath, String[] jvmflags, String shellCommand, int Nt) {
        return new AssignBackendMessage(theJobScheduler, name, host, jvm, classpath, jvmflags, shellCommand, Nt);
    }

    public static JobFrontendMessage assignJobNumber(JobSchedulerRef theJobScheduler, int jobnum, String pjhost) {
        return new AssignJobNumberMessage(theJobScheduler, jobnum, pjhost);
    }

    public static JobFrontendMessage cancelJob(JobSchedulerRef theJobScheduler, String errmsg) {
        return new CancelJobMessage(theJobScheduler, errmsg);
    }

    public static JobFrontendMessage renewLease(JobSchedulerRef theJobScheduler) {
        return new RenewLeaseMessage(theJobScheduler);
    }

    public static JobFrontendMessage backendFinished(JobBackendRef theJobBackend) {
        return new BackendFinishedMessage(theJobBackend);
    }

    public static JobFrontendMessage backendReady(JobBackendRef theJobBackend, int rank, InetSocketAddress middlewareAddress, InetSocketAddress worldAddress, InetSocketAddress frontendAddress) {
        return new BackendReadyMessage(theJobBackend, rank, middlewareAddress, worldAddress, frontendAddress);
    }

    public static JobFrontendMessage cancelJob(JobBackendRef theJobBackend, String errmsg) {
        return new CancelJobMessage(theJobBackend, errmsg);
    }

    public static JobFrontendMessage renewLease(JobBackendRef theJobBackend) {
        return new RenewLeaseMessage(theJobBackend);
    }

    public static JobFrontendMessage requestResource(JobBackendRef theJobBackend, String resourceName) {
        return new RequestResourceMessage(theJobBackend, resourceName);
    }

    public static JobFrontendMessage outputFileOpen(JobBackendRef theJobBackend, int bfd, File file, boolean append) {
        return new OutputFileOpenMessage(theJobBackend, bfd, file, append);
    }

    public static JobFrontendMessage outputFileWrite(JobBackendRef theJobBackend, int ffd, int len) {
        return new OutputFileWriteMessage(theJobBackend, ffd, len);
    }

    public static JobFrontendMessage outputFileFlush(JobBackendRef theJobBackend, int ffd) {
        return new OutputFileFlushMessage(theJobBackend, ffd);
    }

    public static JobFrontendMessage outputFileClose(JobBackendRef theJobBackend, int ffd) {
        return new OutputFileCloseMessage(theJobBackend, ffd);
    }

    public static JobFrontendMessage inputFileOpen(JobBackendRef theJobBackend, int bfd, File file) {
        return new InputFileOpenMessage(theJobBackend, bfd, file);
    }

    public static JobFrontendMessage inputFileRead(JobBackendRef theJobBackend, int ffd, int len) {
        return new InputFileReadMessage(theJobBackend, ffd, len);
    }

    public static JobFrontendMessage inputFileSkip(JobBackendRef theJobBackend, int ffd, long len) {
        return new InputFileSkipMessage(theJobBackend, ffd, len);
    }

    public static JobFrontendMessage inputFileClose(JobBackendRef theJobBackend, int ffd) {
        return new InputFileCloseMessage(theJobBackend, ffd);
    }

    public static JobFrontendMessage reportComment(JobBackendRef theJobBackend, int rank, String comment) {
        return new ReportCommentMessage(theJobBackend, rank, comment);
    }

    public void invoke(JobFrontendRef theJobFrontend, JobSchedulerRef theJobScheduler) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void invoke(JobFrontendRef theJobFrontend, JobBackendRef theJobBackend) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    private static class AssignBackendMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = 4426930548078115598L;
        private String name;
        private String host;
        private String jvm;
        private String classpath;
        private String[] jvmflags;
        private String shellCommand;
        private int Nt;

        public AssignBackendMessage() {
        }

        public AssignBackendMessage(JobSchedulerRef theJobScheduler, String name, String host, String jvm, String classpath, String[] jvmflags, String shellCommand, int Nt) {
            super(4);
            this.name = name;
            this.host = host;
            this.jvm = jvm;
            this.classpath = classpath;
            this.jvmflags = jvmflags;
            this.shellCommand = shellCommand;
            this.Nt = Nt;
        }

        @Override
        public void invoke(JobFrontendRef theJobFrontend, JobSchedulerRef theJobScheduler) throws IOException {
            theJobFrontend.assignBackend(theJobScheduler, this.name, this.host, this.jvm, this.classpath, this.jvmflags, this.shellCommand, this.Nt);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.name);
            out.writeUTF(this.host);
            out.writeUTF(this.jvm);
            out.writeUTF(this.classpath);
            int n = this.jvmflags.length;
            out.writeInt(n);
            for (int i = 0; i < n; ++i) {
                out.writeUTF(this.jvmflags[i]);
            }
            out.writeUTF(this.shellCommand);
            out.writeInt(this.Nt);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.name = in.readUTF();
            this.host = in.readUTF();
            this.jvm = in.readUTF();
            this.classpath = in.readUTF();
            int n = in.readInt();
            this.jvmflags = new String[n];
            for (int i = 0; i < n; ++i) {
                this.jvmflags[i] = in.readUTF();
            }
            this.shellCommand = in.readUTF();
            this.Nt = in.readInt();
        }
    }

    private static class AssignJobNumberMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = -197099388467750972L;
        private int jobnum;
        private String pjhost;

        public AssignJobNumberMessage() {
        }

        public AssignJobNumberMessage(JobSchedulerRef theJobScheduler, int jobnum, String pjhost) {
            super(4);
            this.jobnum = jobnum;
            this.pjhost = pjhost;
        }

        @Override
        public void invoke(JobFrontendRef theJobFrontend, JobSchedulerRef theJobScheduler) throws IOException {
            theJobFrontend.assignJobNumber(theJobScheduler, this.jobnum, this.pjhost);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.jobnum);
            out.writeUTF(this.pjhost);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.jobnum = in.readInt();
            this.pjhost = in.readUTF();
        }
    }

    private static class CancelJobMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = -2009079595329812496L;
        private String errmsg;

        public CancelJobMessage() {
        }

        public CancelJobMessage(JobSchedulerRef theJobScheduler, String errmsg) {
            super(4);
            this.errmsg = errmsg;
        }

        public CancelJobMessage(JobBackendRef theJobBackend, String errmsg) {
            super(1);
            this.errmsg = errmsg;
        }

        @Override
        public void invoke(JobFrontendRef theJobFrontend, JobSchedulerRef theJobScheduler) throws IOException {
            theJobFrontend.cancelJob(theJobScheduler, this.errmsg);
        }

        @Override
        public void invoke(JobFrontendRef theJobFrontend, JobBackendRef theJobBackend) throws IOException {
            theJobFrontend.cancelJob(theJobBackend, this.errmsg);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.errmsg);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.errmsg = in.readUTF();
        }
    }

    private static class RenewLeaseMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = -9030468939160436622L;

        public RenewLeaseMessage() {
        }

        public RenewLeaseMessage(JobSchedulerRef theJobScheduler) {
            super(4);
        }

        public RenewLeaseMessage(JobBackendRef theJobBackend) {
            super(1);
        }

        @Override
        public void invoke(JobFrontendRef theJobFrontend, JobSchedulerRef theJobScheduler) throws IOException {
            theJobFrontend.renewLease(theJobScheduler);
        }

        @Override
        public void invoke(JobFrontendRef theJobFrontend, JobBackendRef theJobBackend) throws IOException {
            theJobFrontend.renewLease(theJobBackend);
        }
    }

    private static class BackendFinishedMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = 759872032212034107L;

        public BackendFinishedMessage() {
        }

        public BackendFinishedMessage(JobBackendRef theJobBackend) {
            super(1);
        }

        @Override
        public void invoke(JobFrontendRef theJobFrontend, JobBackendRef theJobBackend) throws IOException {
            theJobFrontend.backendFinished(theJobBackend);
        }
    }

    private static class BackendReadyMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = -8872540352133660209L;
        private int rank;
        private InetSocketAddress middlewareAddress;
        private InetSocketAddress worldAddress;
        private InetSocketAddress frontendAddress;

        public BackendReadyMessage() {
        }

        public BackendReadyMessage(JobBackendRef theJobBackend, int rank, InetSocketAddress middlewareAddress, InetSocketAddress worldAddress, InetSocketAddress frontendAddress) {
            super(1);
            this.rank = rank;
            this.middlewareAddress = middlewareAddress;
            this.worldAddress = worldAddress;
            this.frontendAddress = frontendAddress;
        }

        @Override
        public void invoke(JobFrontendRef theJobFrontend, JobBackendRef theJobBackend) throws IOException {
            theJobFrontend.backendReady(theJobBackend, this.rank, this.middlewareAddress, this.worldAddress, this.frontendAddress);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.rank);
            out.writeObject(this.middlewareAddress);
            out.writeObject(this.worldAddress);
            out.writeObject(this.frontendAddress);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.rank = in.readInt();
            this.middlewareAddress = (InetSocketAddress)in.readObject();
            this.worldAddress = (InetSocketAddress)in.readObject();
            this.frontendAddress = (InetSocketAddress)in.readObject();
        }
    }

    private static class RequestResourceMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = 9184806604713339263L;
        private String resourceName;

        public RequestResourceMessage() {
        }

        public RequestResourceMessage(JobBackendRef theJobBackend, String resourceName) {
            super(1);
            this.resourceName = resourceName;
        }

        @Override
        public void invoke(JobFrontendRef theJobFrontend, JobBackendRef theJobBackend) throws IOException {
            theJobFrontend.requestResource(theJobBackend, this.resourceName);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.resourceName);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.resourceName = in.readUTF();
        }
    }

    private static class OutputFileOpenMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = -4987754930269039852L;
        private int bfd;
        private File file;
        private boolean append;

        public OutputFileOpenMessage() {
        }

        public OutputFileOpenMessage(JobBackendRef theJobBackend, int bfd, File file, boolean append) {
            super(1);
            this.bfd = bfd;
            this.file = file;
            this.append = append;
        }

        @Override
        public void invoke(JobFrontendRef theJobFrontend, JobBackendRef theJobBackend) throws IOException {
            theJobFrontend.outputFileOpen(theJobBackend, this.bfd, this.file, this.append);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.bfd);
            out.writeBoolean(this.append);
            out.writeObject(this.file);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.bfd = in.readInt();
            this.append = in.readBoolean();
            this.file = (File)in.readObject();
        }
    }

    private static class OutputFileWriteMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = -4460426636308841602L;
        private int ffd;
        private int len;

        public OutputFileWriteMessage() {
        }

        public OutputFileWriteMessage(JobBackendRef theJobBackend, int ffd, int len) {
            super(1);
            this.ffd = ffd;
            this.len = len;
        }

        @Override
        public void invoke(JobFrontendRef theJobFrontend, JobBackendRef theJobBackend) throws IOException {
            theJobFrontend.outputFileWrite(theJobBackend, this.ffd, null, 0, this.len);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.ffd);
            out.writeInt(this.len);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.ffd = in.readInt();
            this.len = in.readInt();
        }
    }

    private static class OutputFileFlushMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = 7074849708663078210L;
        private int ffd;

        public OutputFileFlushMessage() {
        }

        public OutputFileFlushMessage(JobBackendRef theJobBackend, int ffd) {
            super(1);
            this.ffd = ffd;
        }

        @Override
        public void invoke(JobFrontendRef theJobFrontend, JobBackendRef theJobBackend) throws IOException {
            theJobFrontend.outputFileFlush(theJobBackend, this.ffd);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.ffd);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.ffd = in.readInt();
        }
    }

    private static class OutputFileCloseMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = -5637017577338427153L;
        private int ffd;

        public OutputFileCloseMessage() {
        }

        public OutputFileCloseMessage(JobBackendRef theJobBackend, int ffd) {
            super(1);
            this.ffd = ffd;
        }

        @Override
        public void invoke(JobFrontendRef theJobFrontend, JobBackendRef theJobBackend) throws IOException {
            theJobFrontend.outputFileClose(theJobBackend, this.ffd);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.ffd);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.ffd = in.readInt();
        }
    }

    private static class InputFileOpenMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = -791306998166025239L;
        private int bfd;
        private File file;

        public InputFileOpenMessage() {
        }

        public InputFileOpenMessage(JobBackendRef theJobBackend, int bfd, File file) {
            super(1);
            this.bfd = bfd;
            this.file = file;
        }

        @Override
        public void invoke(JobFrontendRef theJobFrontend, JobBackendRef theJobBackend) throws IOException {
            theJobFrontend.inputFileOpen(theJobBackend, this.bfd, this.file);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.bfd);
            out.writeObject(this.file);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.bfd = in.readInt();
            this.file = (File)in.readObject();
        }
    }

    private static class InputFileReadMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = 7727558874589005187L;
        private int ffd;
        private int len;

        public InputFileReadMessage() {
        }

        public InputFileReadMessage(JobBackendRef theJobBackend, int ffd, int len) {
            super(1);
            this.ffd = ffd;
            this.len = len;
        }

        @Override
        public void invoke(JobFrontendRef theJobFrontend, JobBackendRef theJobBackend) throws IOException {
            theJobFrontend.inputFileRead(theJobBackend, this.ffd, this.len);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.ffd);
            out.writeInt(this.len);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.ffd = in.readInt();
            this.len = in.readInt();
        }
    }

    private static class InputFileSkipMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = 7867427744015166954L;
        private int ffd;
        private long len;

        public InputFileSkipMessage() {
        }

        public InputFileSkipMessage(JobBackendRef theJobBackend, int ffd, long len) {
            super(1);
            this.ffd = ffd;
            this.len = len;
        }

        @Override
        public void invoke(JobFrontendRef theJobFrontend, JobBackendRef theJobBackend) throws IOException {
            theJobFrontend.inputFileSkip(theJobBackend, this.ffd, this.len);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.ffd);
            out.writeLong(this.len);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.ffd = in.readInt();
            this.len = in.readLong();
        }
    }

    private static class InputFileCloseMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = 1223549294646718409L;
        private int ffd;

        public InputFileCloseMessage() {
        }

        public InputFileCloseMessage(JobBackendRef theJobBackend, int ffd) {
            super(1);
            this.ffd = ffd;
        }

        @Override
        public void invoke(JobFrontendRef theJobFrontend, JobBackendRef theJobBackend) throws IOException {
            theJobFrontend.inputFileClose(theJobBackend, this.ffd);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.ffd);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.ffd = in.readInt();
        }
    }

    private static class ReportCommentMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = 1092254806177598252L;
        private int rank;
        private String comment;

        public ReportCommentMessage() {
        }

        public ReportCommentMessage(JobBackendRef theJobBackend, int rank, String comment) {
            super(1);
            this.rank = rank;
            this.comment = comment == null ? "" : comment;
        }

        @Override
        public void invoke(JobFrontendRef theJobFrontend, JobBackendRef theJobBackend) throws IOException {
            theJobFrontend.reportComment(theJobBackend, this.rank, this.comment);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.rank);
            out.writeUTF(this.comment);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.rank = in.readInt();
            this.comment = in.readUTF();
        }
    }
}

