/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontendRef;
import edu.rit.pj.cluster.Message;
import edu.rit.util.ByteSequence;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Properties;

public abstract class JobBackendMessage
extends Message
implements Externalizable {
    private static final long serialVersionUID = 3747140854797048519L;

    public JobBackendMessage() {
    }

    public JobBackendMessage(int theTag) {
        super(theTag);
    }

    public static JobBackendMessage cancelJob(JobFrontendRef theJobFrontend, String errmsg) {
        return new CancelJobMessage(theJobFrontend, errmsg);
    }

    public static JobBackendMessage commenceJob(JobFrontendRef theJobFrontend, InetSocketAddress[] middlewareAddress, InetSocketAddress[] worldAddress, InetSocketAddress[] frontendAddress, Properties properties, String mainClassName, String[] args) {
        return new CommenceJobMessage(theJobFrontend, middlewareAddress, worldAddress, frontendAddress, properties, mainClassName, args);
    }

    public static JobBackendMessage jobFinished(JobFrontendRef theJobFrontend) {
        return new JobFinishedMessage(theJobFrontend);
    }

    public static JobBackendMessage renewLease(JobFrontendRef theJobFrontend) {
        return new RenewLeaseMessage(theJobFrontend);
    }

    public static JobBackendMessage reportResource(JobFrontendRef theJobFrontend, String resourceName, byte[] content) {
        return new ReportResourceMessage(theJobFrontend, resourceName, content);
    }

    public static JobBackendMessage reportResource(JobFrontendRef theJobFrontend, String resourceName, ByteSequence content) {
        return new ReportResourceMessage(theJobFrontend, resourceName, content);
    }

    public static JobBackendMessage outputFileOpenResult(JobFrontendRef theJobFrontend, int bfd, int ffd, IOException exc) {
        return new OutputFileOpenResultMessage(theJobFrontend, bfd, ffd, exc);
    }

    public static JobBackendMessage outputFileWriteResult(JobFrontendRef theJobFrontend, int ffd, IOException exc) {
        return new OutputFileWriteResultMessage(theJobFrontend, ffd, exc);
    }

    public static JobBackendMessage outputFileFlushResult(JobFrontendRef theJobFrontend, int ffd, IOException exc) {
        return new OutputFileFlushResultMessage(theJobFrontend, ffd, exc);
    }

    public static JobBackendMessage outputFileCloseResult(JobFrontendRef theJobFrontend, int ffd, IOException exc) {
        return new OutputFileCloseResultMessage(theJobFrontend, ffd, exc);
    }

    public static JobBackendMessage inputFileOpenResult(JobFrontendRef theJobFrontend, int bfd, int ffd, IOException exc) {
        return new InputFileOpenResultMessage(theJobFrontend, bfd, ffd, exc);
    }

    public static JobBackendMessage inputFileReadResult(JobFrontendRef theJobFrontend, int ffd, int len, IOException exc) {
        return new InputFileReadResultMessage(theJobFrontend, ffd, len, exc);
    }

    public static JobBackendMessage inputFileSkipResult(JobFrontendRef theJobFrontend, int ffd, long len, IOException exc) {
        return new InputFileSkipResultMessage(theJobFrontend, ffd, len, exc);
    }

    public static JobBackendMessage inputFileCloseResult(JobFrontendRef theJobFrontend, int ffd, IOException exc) {
        return new InputFileCloseResultMessage(theJobFrontend, ffd, exc);
    }

    public void invoke(JobBackendRef theJobBackend, JobFrontendRef theJobFrontend) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    private static class CancelJobMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = -1706674774429384654L;
        private String errmsg;

        public CancelJobMessage() {
        }

        public CancelJobMessage(JobFrontendRef theJobFrontend, String errmsg) {
            super(2);
            this.errmsg = errmsg;
        }

        @Override
        public void invoke(JobBackendRef theJobBackend, JobFrontendRef theJobFrontend) throws IOException {
            theJobBackend.cancelJob(theJobFrontend, this.errmsg);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.errmsg);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.errmsg = in.readUTF();
        }
    }

    private static class CommenceJobMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = -8262872991140404870L;
        private InetSocketAddress[] middlewareAddress;
        private InetSocketAddress[] worldAddress;
        private InetSocketAddress[] frontendAddress;
        private Properties properties;
        private String mainClassName;
        private String[] args;

        public CommenceJobMessage() {
        }

        public CommenceJobMessage(JobFrontendRef theJobFrontend, InetSocketAddress[] middlewareAddress, InetSocketAddress[] worldAddress, InetSocketAddress[] frontendAddress, Properties properties, String mainClassName, String[] args) {
            super(2);
            this.middlewareAddress = middlewareAddress;
            this.worldAddress = worldAddress;
            this.frontendAddress = frontendAddress;
            this.properties = properties;
            this.mainClassName = mainClassName;
            this.args = args;
        }

        @Override
        public void invoke(JobBackendRef theJobBackend, JobFrontendRef theJobFrontend) throws IOException {
            theJobBackend.commenceJob(theJobFrontend, this.middlewareAddress, this.worldAddress, this.frontendAddress, this.properties, this.mainClassName, this.args);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            int i;
            out.writeInt(this.properties.size());
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                out.writeUTF((String)entry.getKey());
                out.writeUTF((String)entry.getValue());
            }
            out.writeUTF(this.mainClassName);
            out.writeInt(this.args.length);
            for (String arg : this.args) {
                out.writeUTF(arg);
            }
            int n1 = this.middlewareAddress.length;
            int n2 = this.worldAddress.length;
            int n3 = this.frontendAddress == null ? 0 : this.frontendAddress.length;
            out.writeInt(n1);
            out.writeInt(n2);
            out.writeInt(n3);
            for (i = 0; i < n1; ++i) {
                out.writeObject(this.middlewareAddress[i]);
            }
            for (i = 0; i < n2; ++i) {
                out.writeObject(this.worldAddress[i]);
            }
            for (i = 0; i < n3; ++i) {
                out.writeObject(this.frontendAddress[i]);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int i;
            int i2;
            int n = in.readInt();
            this.properties = new Properties();
            for (i2 = 0; i2 < n; ++i2) {
                this.properties.setProperty(in.readUTF(), in.readUTF());
            }
            this.mainClassName = in.readUTF();
            n = in.readInt();
            this.args = new String[n];
            for (i2 = 0; i2 < n; ++i2) {
                this.args[i2] = in.readUTF();
            }
            int n1 = in.readInt();
            int n2 = in.readInt();
            int n3 = in.readInt();
            this.middlewareAddress = new InetSocketAddress[n1];
            for (i = 0; i < n1; ++i) {
                this.middlewareAddress[i] = (InetSocketAddress)in.readObject();
            }
            this.worldAddress = new InetSocketAddress[n2];
            for (i = 0; i < n2; ++i) {
                this.worldAddress[i] = (InetSocketAddress)in.readObject();
            }
            if (n3 > 0) {
                this.frontendAddress = new InetSocketAddress[n3];
                for (i = 0; i < n3; ++i) {
                    this.frontendAddress[i] = (InetSocketAddress)in.readObject();
                }
            }
        }
    }

    private static class JobFinishedMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = 1363549433797859519L;

        public JobFinishedMessage() {
        }

        public JobFinishedMessage(JobFrontendRef theJobFrontend) {
            super(2);
        }

        @Override
        public void invoke(JobBackendRef theJobBackend, JobFrontendRef theJobFrontend) throws IOException {
            theJobBackend.jobFinished(theJobFrontend);
        }
    }

    private static class RenewLeaseMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = -5146916532326180730L;

        public RenewLeaseMessage() {
        }

        public RenewLeaseMessage(JobFrontendRef theJobFrontend) {
            super(2);
        }

        @Override
        public void invoke(JobBackendRef theJobBackend, JobFrontendRef theJobFrontend) throws IOException {
            theJobBackend.renewLease(theJobFrontend);
        }
    }

    private static class ReportResourceMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = 8709827200639757997L;
        private String resourceName;
        private ByteSequence contentSeq;
        private byte[] content;

        public ReportResourceMessage() {
        }

        public ReportResourceMessage(JobFrontendRef theJobFrontend, String resourceName, byte[] content) {
            super(2);
            this.resourceName = resourceName;
            this.content = content;
        }

        public ReportResourceMessage(JobFrontendRef theJobFrontend, String resourceName, ByteSequence content) {
            super(2);
            this.resourceName = resourceName;
            this.contentSeq = content;
        }

        @Override
        public void invoke(JobBackendRef theJobBackend, JobFrontendRef theJobFrontend) throws IOException {
            if (this.content != null) {
                theJobBackend.reportResource(theJobFrontend, this.resourceName, this.content);
            } else {
                theJobBackend.reportResource(theJobFrontend, this.resourceName, this.contentSeq);
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.resourceName);
            if (this.content != null) {
                out.writeInt(this.content.length);
                out.write(this.content);
            } else if (this.contentSeq != null) {
                out.writeInt(this.contentSeq.length());
                this.contentSeq.write(out);
            } else {
                out.writeInt(-1);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.resourceName = in.readUTF();
            int n = in.readInt();
            if (n < 0) {
                this.content = null;
            } else {
                this.content = new byte[n];
                in.readFully(this.content);
            }
        }
    }

    private static class OutputFileOpenResultMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = 1460222094425830409L;
        private int bfd;
        private int ffd;
        private IOException exc;

        public OutputFileOpenResultMessage() {
        }

        public OutputFileOpenResultMessage(JobFrontendRef theJobFrontend, int bfd, int ffd, IOException exc) {
            super(2);
            this.bfd = bfd;
            this.ffd = ffd;
            this.exc = exc;
        }

        @Override
        public void invoke(JobBackendRef theJobBackend, JobFrontendRef theJobFrontend) throws IOException {
            theJobBackend.outputFileOpenResult(theJobFrontend, this.bfd, this.ffd, this.exc);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.bfd);
            out.writeInt(this.ffd);
            out.writeObject(this.exc);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.bfd = in.readInt();
            this.ffd = in.readInt();
            this.exc = (IOException)in.readObject();
        }
    }

    private static class OutputFileWriteResultMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = -4734876024127370851L;
        private int ffd;
        private IOException exc;

        public OutputFileWriteResultMessage() {
        }

        public OutputFileWriteResultMessage(JobFrontendRef theJobFrontend, int ffd, IOException exc) {
            super(2);
            this.ffd = ffd;
            this.exc = exc;
        }

        @Override
        public void invoke(JobBackendRef theJobBackend, JobFrontendRef theJobFrontend) throws IOException {
            theJobBackend.outputFileWriteResult(theJobFrontend, this.ffd, this.exc);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.ffd);
            out.writeObject(this.exc);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.ffd = in.readInt();
            this.exc = (IOException)in.readObject();
        }
    }

    private static class OutputFileFlushResultMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = 8921581871627030306L;
        private int ffd;
        private IOException exc;

        public OutputFileFlushResultMessage() {
        }

        public OutputFileFlushResultMessage(JobFrontendRef theJobFrontend, int ffd, IOException exc) {
            super(2);
            this.ffd = ffd;
            this.exc = exc;
        }

        @Override
        public void invoke(JobBackendRef theJobBackend, JobFrontendRef theJobFrontend) throws IOException {
            theJobBackend.outputFileFlushResult(theJobFrontend, this.ffd, this.exc);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.ffd);
            out.writeObject(this.exc);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.ffd = in.readInt();
            this.exc = (IOException)in.readObject();
        }
    }

    private static class OutputFileCloseResultMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = 5976163600237430235L;
        private int ffd;
        private IOException exc;

        public OutputFileCloseResultMessage() {
        }

        public OutputFileCloseResultMessage(JobFrontendRef theJobFrontend, int ffd, IOException exc) {
            super(2);
            this.ffd = ffd;
            this.exc = exc;
        }

        @Override
        public void invoke(JobBackendRef theJobBackend, JobFrontendRef theJobFrontend) throws IOException {
            theJobBackend.outputFileCloseResult(theJobFrontend, this.ffd, this.exc);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.ffd);
            out.writeObject(this.exc);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.ffd = in.readInt();
            this.exc = (IOException)in.readObject();
        }
    }

    private static class InputFileOpenResultMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = -1082499193559062581L;
        private int bfd;
        private int ffd;
        private IOException exc;

        public InputFileOpenResultMessage() {
        }

        public InputFileOpenResultMessage(JobFrontendRef theJobFrontend, int bfd, int ffd, IOException exc) {
            super(2);
            this.bfd = bfd;
            this.ffd = ffd;
            this.exc = exc;
        }

        @Override
        public void invoke(JobBackendRef theJobBackend, JobFrontendRef theJobFrontend) throws IOException {
            theJobBackend.inputFileOpenResult(theJobFrontend, this.bfd, this.ffd, this.exc);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.bfd);
            out.writeInt(this.ffd);
            out.writeObject(this.exc);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.bfd = in.readInt();
            this.ffd = in.readInt();
            this.exc = (IOException)in.readObject();
        }
    }

    private static class InputFileReadResultMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = 4542261695089387333L;
        private int ffd;
        private int len;
        private IOException exc;

        public InputFileReadResultMessage() {
        }

        public InputFileReadResultMessage(JobFrontendRef theJobFrontend, int ffd, int len, IOException exc) {
            super(2);
            this.ffd = ffd;
            this.len = len;
            this.exc = exc;
        }

        @Override
        public void invoke(JobBackendRef theJobBackend, JobFrontendRef theJobFrontend) throws IOException {
            theJobBackend.inputFileReadResult(theJobFrontend, this.ffd, null, this.len, this.exc);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.ffd);
            out.writeInt(this.len);
            out.writeObject(this.exc);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.ffd = in.readInt();
            this.len = in.readInt();
            this.exc = (IOException)in.readObject();
        }
    }

    private static class InputFileSkipResultMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = 5050948958179612039L;
        private int ffd;
        private long len;
        private IOException exc;

        public InputFileSkipResultMessage() {
        }

        public InputFileSkipResultMessage(JobFrontendRef theJobFrontend, int ffd, long len, IOException exc) {
            super(2);
            this.ffd = ffd;
            this.len = len;
            this.exc = exc;
        }

        @Override
        public void invoke(JobBackendRef theJobBackend, JobFrontendRef theJobFrontend) throws IOException {
            theJobBackend.inputFileSkipResult(theJobFrontend, this.ffd, this.len, this.exc);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.ffd);
            out.writeLong(this.len);
            out.writeObject(this.exc);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.ffd = in.readInt();
            this.len = in.readLong();
            this.exc = (IOException)in.readObject();
        }
    }

    private static class InputFileCloseResultMessage
    extends JobBackendMessage {
        private static final long serialVersionUID = -5645040374361899565L;
        private int ffd;
        private IOException exc;

        public InputFileCloseResultMessage() {
        }

        public InputFileCloseResultMessage(JobFrontendRef theJobFrontend, int ffd, IOException exc) {
            super(2);
            this.ffd = ffd;
            this.exc = exc;
        }

        @Override
        public void invoke(JobBackendRef theJobBackend, JobFrontendRef theJobFrontend) throws IOException {
            theJobBackend.inputFileCloseResult(theJobFrontend, this.ffd, this.exc);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.ffd);
            out.writeObject(this.exc);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.ffd = in.readInt();
            this.exc = (IOException)in.readObject();
        }
    }
}

