/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.mp.ChannelGroup;
import edu.rit.mp.ChannelGroupClosedException;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.Status;
import edu.rit.mp.buf.ObjectItemBuf;
import edu.rit.pj.cluster.BackendClassLoader;
import edu.rit.pj.cluster.BackendFileReader;
import edu.rit.pj.cluster.BackendFileWriter;
import edu.rit.pj.cluster.Constants;
import edu.rit.pj.cluster.JobBackendMessage;
import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontendProxy;
import edu.rit.pj.cluster.JobFrontendRef;
import edu.rit.pj.cluster.ResourceCache;
import edu.rit.util.ByteSequence;
import edu.rit.util.Timer;
import edu.rit.util.TimerThread;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class JobBackend
implements Runnable,
JobBackendRef {
    private static final Logger logger = Logger.getLogger(JobBackend.class.getName());
    private static JobBackend theJobBackend;
    private final String username;
    private final int jobnum;
    private final int K;
    private final int rank;
    private final boolean hasFrontendComm;
    private final String frontendHost;
    private final int frontendPort;
    private final String backendHost;
    FileHandler fileHandler = null;
    private final TimerThread myLeaseTimerThread;
    private final Timer myFrontendRenewTimer;
    private final Timer myFrontendExpireTimer;
    private final ChannelGroup myMiddlewareChannelGroup;
    private InetSocketAddress[] myMiddlewareAddress;
    private final JobFrontendRef myJobFrontend;
    private final ResourceCache myResourceCache;
    private final BackendClassLoader myClassLoader;
    private final ChannelGroup myWorldChannelGroup;
    private InetSocketAddress[] myWorldAddress;
    private ChannelGroup myFrontendChannelGroup;
    private InetSocketAddress[] myFrontendAddress;
    private Properties myProperties;
    private String myMainClassName;
    private String[] myArgs;
    private boolean commence;
    private final ObjectItemBuf<JobBackendMessage> myBuffer = ObjectBuf.buffer((JobBackendMessage)null);
    private boolean continueRun = true;
    private final CountDownLatch runFinished = new CountDownLatch(1);
    private State myState = State.RUNNING;
    private String myCancelMessage;
    private final PrintStream myJobLauncherLog;
    private final BackendFileWriter myFileWriter;
    private final BackendFileReader myFileReader;

    private JobBackend(String username, int jobnum, int K, int rank, boolean hasFrontendComm, String frontendHost, int frontendPort, String backendHost) throws IOException {
        this.username = username;
        this.jobnum = jobnum;
        this.K = K;
        this.rank = rank;
        this.hasFrontendComm = hasFrontendComm;
        this.frontendHost = frontendHost;
        this.frontendPort = frontendPort;
        this.backendHost = backendHost;
        StringBuilder sb = new StringBuilder();
        boolean verbose = Boolean.parseBoolean(System.getProperty("pj.verbose", "false"));
        if (verbose) {
            try {
                Handler[] defaultHandlers;
                Logger defaultLogger = LogManager.getLogManager().getLogger("");
                for (Handler h : defaultHandlers = defaultLogger.getHandlers()) {
                    defaultLogger.removeHandler(h);
                }
                File dir = new File(Integer.toString(this.rank));
                if (!dir.exists()) {
                    boolean success = dir.mkdir();
                    sb.append(String.format("\n Creation of logging directory %s: %b", dir, success));
                }
                String logFile = dir.getAbsolutePath() + File.separator + "backend.log";
                this.fileHandler = new FileHandler(logFile);
                sb.append(String.format("\n Log file: %s", logFile));
                this.fileHandler.setFormatter(new SimpleFormatter());
                logger.addHandler(this.fileHandler);
                logger.setLevel(Level.INFO);
            }
            catch (Exception e) {
                logger.setLevel(Level.OFF);
            }
        } else {
            logger.setLevel(Level.OFF);
        }
        sb.append(String.format("\n Username:          %s", this.username));
        sb.append(String.format("\n Job number:        %d", this.jobnum));
        sb.append(String.format("\n Nodes:             %d", this.K));
        sb.append(String.format("\n Rank:              %d", this.rank));
        sb.append(String.format("\n Has Frontend Comm: %b", this.hasFrontendComm));
        sb.append(String.format("\n Frontend Host:     %s", this.frontendHost));
        sb.append(String.format("\n Frontend Port:     %d", this.frontendPort));
        sb.append(String.format("\n Backend Host:      %s", this.backendHost));
        logger.log(Level.INFO, sb.toString());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.shutdown()));
        logger.log(Level.INFO, " Set up lease timer thread.");
        this.myLeaseTimerThread = new TimerThread();
        this.myLeaseTimerThread.setDaemon(true);
        this.myLeaseTimerThread.start();
        logger.log(Level.INFO, String.format(" Create frontend renew timer (%d sec).", Constants.LEASE_RENEW_INTERVAL / 1000L));
        this.myFrontendRenewTimer = this.myLeaseTimerThread.createTimer(timer -> {
            try {
                this.frontendRenewTimeout();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        logger.log(Level.INFO, String.format(" Create frontend expire timer (%d sec).", Constants.LEASE_EXPIRE_INTERVAL / 1000L));
        this.myFrontendExpireTimer = this.myLeaseTimerThread.createTimer(timer -> {
            try {
                this.frontendExpireTimeout();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        this.myFrontendExpireTimer.start(Constants.LEASE_EXPIRE_INTERVAL);
        logger.log(Level.INFO, " Set up middleware channel group.");
        this.myMiddlewareChannelGroup = new ChannelGroup(new InetSocketAddress(backendHost, 0));
        this.myMiddlewareChannelGroup.startListening();
        logger.log(Level.INFO, " Set up job frontend proxy.");
        this.myJobFrontend = new JobFrontendProxy(this.myMiddlewareChannelGroup, this.myMiddlewareChannelGroup.connect(new InetSocketAddress(frontendHost, frontendPort)));
        logger.log(Level.INFO, " The job frontend proxy has been set up.");
        logger.log(Level.INFO, " Start frontend lease renewal timer.");
        this.myFrontendRenewTimer.start(Constants.LEASE_RENEW_INTERVAL, Constants.LEASE_RENEW_INTERVAL);
        this.myResourceCache = new ResourceCache();
        this.myClassLoader = new BackendClassLoader(this.getClass().getClassLoader(), this, this.myJobFrontend, this.myResourceCache);
        logger.log(Level.INFO, " Set up world communicator channel group.");
        this.myWorldChannelGroup = new ChannelGroup(new InetSocketAddress(backendHost, 0));
        this.myWorldChannelGroup.setAlternateClassLoader(this.myClassLoader);
        if (hasFrontendComm) {
            logger.log(Level.INFO, " Set up frontend communicator channel group.");
            this.myFrontendChannelGroup = new ChannelGroup(new InetSocketAddress(backendHost, 0));
            this.myFrontendChannelGroup.setAlternateClassLoader(this.myClassLoader);
        }
        logger.log(Level.INFO, " Set up backend file writer and reader.");
        this.myFileWriter = new BackendFileWriter(this.myJobFrontend, this);
        this.myFileReader = new BackendFileReader(this.myJobFrontend, this);
        logger.log(Level.INFO, " Redirect standard input, standard output, and standard error to job frontend.");
        System.in.close();
        System.out.close();
        this.myJobLauncherLog = System.err;
        System.setIn(this.myFileReader.in);
        System.setOut(this.myFileWriter.out);
        System.setErr(this.myFileWriter.err);
        logger.log(Level.INFO, " Tell job frontend we're ready.");
        this.myJobFrontend.backendReady(this, rank, this.myMiddlewareChannelGroup.listenAddress(), this.myWorldChannelGroup.listenAddress(), hasFrontendComm ? this.myFrontendChannelGroup.listenAddress() : null);
    }

    @Override
    public void run() {
        Status status = null;
        JobBackendMessage message = null;
        try {
            while (this.continueRun) {
                status = this.myMiddlewareChannelGroup.receive(null, null, this.myBuffer);
                message = (JobBackendMessage)this.myBuffer.item;
                message.invoke(this, this.myJobFrontend);
                this.myBuffer.item = null;
                status = null;
                message = null;
            }
            this.reportRunFinished();
        }
        catch (ChannelGroupClosedException exc) {
            this.reportRunFinished();
        }
        catch (Throwable exc) {
            this.reportRunFinished();
            this.terminateCancelJob(exc);
        }
        switch (this.myState.ordinal()) {
            case 1: 
            case 2: {
                System.exit(1);
                break;
            }
        }
    }

    @Override
    public synchronized void cancelJob(JobFrontendRef theJobFrontend, String errmsg) throws IOException {
        this.terminateNoReport();
    }

    @Override
    public synchronized void commenceJob(JobFrontendRef theJobFrontend, InetSocketAddress[] middlewareAddress, InetSocketAddress[] worldAddress, InetSocketAddress[] frontendAddress, Properties properties, String mainClassName, String[] args) throws IOException {
        this.myMiddlewareAddress = middlewareAddress;
        this.myWorldAddress = worldAddress;
        this.myFrontendAddress = frontendAddress;
        this.myProperties = properties;
        this.myMainClassName = mainClassName;
        this.myArgs = args;
        this.commence = true;
        this.notifyAll();
    }

    @Override
    public synchronized void jobFinished(JobFrontendRef theJobFrontend) throws IOException {
        this.continueRun = false;
    }

    @Override
    public synchronized void renewLease(JobFrontendRef theJobFrontend) throws IOException {
        this.myFrontendExpireTimer.start(Constants.LEASE_EXPIRE_INTERVAL);
    }

    @Override
    public synchronized void reportResource(JobFrontendRef theJobFrontend, String resourceName, byte[] content) throws IOException {
        this.myResourceCache.put(resourceName, content);
    }

    @Override
    public synchronized void reportResource(JobFrontendRef theJobFrontend, String resourceName, ByteSequence content) throws IOException {
        this.myResourceCache.put(resourceName, content == null ? null : content.toByteArray());
    }

    @Override
    public synchronized void outputFileOpenResult(JobFrontendRef theJobFrontend, int bfd, int ffd, IOException exc) throws IOException {
        this.myFileWriter.outputFileOpenResult(theJobFrontend, bfd, ffd, exc);
    }

    @Override
    public synchronized void outputFileWriteResult(JobFrontendRef theJobFrontend, int ffd, IOException exc) throws IOException {
        this.myFileWriter.outputFileWriteResult(theJobFrontend, ffd, exc);
    }

    @Override
    public synchronized void outputFileFlushResult(JobFrontendRef theJobFrontend, int ffd, IOException exc) throws IOException {
        this.myFileWriter.outputFileFlushResult(theJobFrontend, ffd, exc);
    }

    @Override
    public synchronized void outputFileCloseResult(JobFrontendRef theJobFrontend, int ffd, IOException exc) throws IOException {
        this.myFileWriter.outputFileCloseResult(theJobFrontend, ffd, exc);
    }

    @Override
    public synchronized void inputFileOpenResult(JobFrontendRef theJobFrontend, int bfd, int ffd, IOException exc) throws IOException {
        this.myFileReader.inputFileOpenResult(theJobFrontend, bfd, ffd, exc);
    }

    @Override
    public synchronized void inputFileReadResult(JobFrontendRef theJobFrontend, int ffd, byte[] buf, int len, IOException exc) throws IOException {
        this.myFileReader.inputFileReadResult(theJobFrontend, ffd, len, exc);
    }

    @Override
    public synchronized void inputFileSkipResult(JobFrontendRef theJobFrontend, int ffd, long len, IOException exc) throws IOException {
        this.myFileReader.inputFileSkipResult(theJobFrontend, ffd, len, exc);
    }

    @Override
    public synchronized void inputFileCloseResult(JobFrontendRef theJobFrontend, int ffd, IOException exc) throws IOException {
        this.myFileReader.inputFileCloseResult(theJobFrontend, ffd, exc);
    }

    @Override
    public synchronized void close() {
    }

    public String getUserName() {
        return this.username;
    }

    public int getJobNumber() {
        return this.jobnum;
    }

    public int getK() {
        return this.K;
    }

    public int getRank() {
        return this.rank;
    }

    public String getBackendHost() {
        return this.backendHost;
    }

    public boolean hasFrontendCommunicator() {
        return this.hasFrontendComm;
    }

    public ClassLoader getClassLoader() {
        return this.myClassLoader;
    }

    public BackendFileWriter getFileWriter() {
        return this.myFileWriter;
    }

    public BackendFileReader getFileReader() {
        return this.myFileReader;
    }

    public synchronized void waitForCommence() {
        while (!this.commence) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public ChannelGroup getWorldChannelGroup() {
        return this.myWorldChannelGroup;
    }

    public InetSocketAddress[] getWorldAddress() {
        return this.myWorldAddress;
    }

    public ChannelGroup getFrontendChannelGroup() {
        return this.myFrontendChannelGroup;
    }

    public InetSocketAddress[] getFrontendAddress() {
        return this.myFrontendAddress;
    }

    public Properties getProperties() {
        return this.myProperties;
    }

    public String getMainClassName() {
        return this.myMainClassName;
    }

    public String[] getArgs() {
        return this.myArgs;
    }

    public void setComment(String comment) {
        try {
            this.myJobFrontend.reportComment(this, this.rank, comment);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static JobBackend getJobBackend() {
        return theJobBackend;
    }

    private synchronized void frontendRenewTimeout() throws IOException {
        if (this.myFrontendRenewTimer.isTriggered()) {
            this.myJobFrontend.renewLease(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void frontendExpireTimeout() throws IOException {
        boolean doExit = false;
        JobBackend jobBackend = this;
        synchronized (jobBackend) {
            if (this.myFrontendExpireTimer.isTriggered()) {
                this.reportRunFinished();
                if (this.myState == State.RUNNING) {
                    this.myState = State.TERMINATE_NO_REPORT;
                    doExit = true;
                }
            }
        }
        this.myJobLauncherLog.println("Job frontend lease expired");
        if (doExit) {
            System.exit(1);
        }
    }

    private void terminateCancelJob(Throwable exc) {
        this.continueRun = false;
        if (this.myState == State.RUNNING) {
            this.myState = State.TERMINATE_CANCEL_JOB;
            this.myCancelMessage = exc.getClass().getName();
            String msg = exc.getMessage();
            if (msg != null) {
                this.myCancelMessage = this.myCancelMessage + ": " + msg;
            }
        }
    }

    private void terminateNoReport() {
        this.continueRun = false;
        if (this.myState == State.RUNNING) {
            this.myState = State.TERMINATE_NO_REPORT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        JobBackend jobBackend = this;
        synchronized (jobBackend) {
            if (this.myJobFrontend != null) {
                try {
                    switch (this.myState.ordinal()) {
                        case 0: {
                            this.myJobFrontend.backendFinished(this);
                            break;
                        }
                        case 1: {
                            this.myJobFrontend.cancelJob(this, this.myCancelMessage);
                            break;
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.myState = State.TERMINATING;
        }
        this.waitForRunFinished();
        jobBackend = this;
        synchronized (jobBackend) {
            this.myFrontendRenewTimer.stop();
            this.myFrontendExpireTimer.stop();
        }
    }

    private void waitForRunFinished() {
        while (true) {
            try {
                this.runFinished.await();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private void reportRunFinished() {
        this.runFinished.countDown();
    }

    private synchronized void dump() {
        int i;
        System.out.println("********************************");
        System.out.println("username = " + this.username);
        System.out.println("jobnum = " + this.jobnum);
        System.out.println("K = " + this.K);
        System.out.println("rank = " + this.rank);
        System.out.println("hasFrontendComm = " + this.hasFrontendComm);
        for (i = 0; i <= this.K; ++i) {
            System.out.println("myMiddlewareAddress[" + i + "] = " + String.valueOf(this.myMiddlewareAddress[i]));
        }
        for (i = 0; i < this.K; ++i) {
            System.out.println("myWorldAddress[" + i + "] = " + String.valueOf(this.myWorldAddress[i]));
        }
        if (this.hasFrontendComm) {
            for (i = 0; i <= this.K; ++i) {
                System.out.println("myFrontendAddress[" + i + "] = " + String.valueOf(this.myFrontendAddress[i]));
            }
        }
        this.myProperties.list(System.out);
        System.out.println("myMainClassName = " + this.myMainClassName);
        for (i = 0; i < this.myArgs.length; ++i) {
            System.out.println("myArgs[" + i + "] = \"" + this.myArgs[i] + "\"");
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            if (args.length != 8) {
                JobBackend.usage();
            }
            String username = args[0];
            int jobnum = Integer.parseInt(args[1]);
            int K = Integer.parseInt(args[2]);
            int rank = Integer.parseInt(args[3]);
            boolean hasFrontendComm = Boolean.parseBoolean(args[4]);
            String frontendHost = args[5];
            int frontendPort = Integer.parseInt(args[6]);
            String backendHost = args[7];
            theJobBackend = new JobBackend(username, jobnum, K, rank, hasFrontendComm, frontendHost, frontendPort, backendHost);
        }
        catch (Throwable exc) {
            exc.printStackTrace(System.err);
            System.exit(1);
        }
        Thread.currentThread().setContextClassLoader(theJobBackend.getClassLoader());
        logger.log(Level.INFO, " Starting backend Daemon thread.");
        Thread thr = new Thread(theJobBackend);
        thr.setDaemon(true);
        thr.start();
        logger.log(Level.INFO, " Waiting for commence.");
        theJobBackend.waitForCommence();
        logger.log(Level.INFO, " Commencing.");
        Properties backendProperties = System.getProperties();
        Properties frontendProperties = theJobBackend.getProperties();
        for (Map.Entry<Object, Object> entry : frontendProperties.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (backendProperties.getProperty(name) != null) continue;
            backendProperties.setProperty(name, value);
        }
        System.setProperty("java.awt.headless", "true");
        Class<?> mainclass = Class.forName(theJobBackend.getMainClassName(), true, ClassLoader.getSystemClassLoader());
        Method mainmethod = mainclass.getMethod("main", String[].class);
        StringBuilder stringBuilder = new StringBuilder(String.format(" Preparing to invoke main method:\n %s\n With args: ", mainmethod));
        for (String arg : theJobBackend.getArgs()) {
            stringBuilder.append(String.format(" %s", arg));
        }
        stringBuilder.append("\n Backend start-up completed.");
        logger.log(Level.INFO, stringBuilder.toString());
        if (JobBackend.theJobBackend.fileHandler != null) {
            JobBackend.theJobBackend.fileHandler.flush();
            logger.setLevel(Level.OFF);
            JobBackend.theJobBackend.fileHandler.close();
        }
        mainmethod.invoke(null, new Object[]{theJobBackend.getArgs()});
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.pj.cluster.JobBackend <username> <jobnum> <K> <rank> <hasFrontendComm> <frontendHost> <frontendPort> <backendHost>");
        System.exit(1);
    }

    private static enum State {
        RUNNING,
        TERMINATE_CANCEL_JOB,
        TERMINATE_NO_REPORT,
        TERMINATING;

    }
}

