/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.mp.ByteBuf;
import edu.rit.pj.cluster.JobBackendProxy;
import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontend;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;

public class FrontendFileWriter {
    private JobFrontend myJobFrontend;
    private Map<Integer, FileHandler> myFileHandlerForFFD = new HashMap<Integer, FileHandler>();
    private int myNextFFD = 3;

    public FrontendFileWriter(JobFrontend theJobFrontend) {
        this.myJobFrontend = theJobFrontend;
        this.myFileHandlerForFFD.put(1, new FileHandler(this, System.out));
        this.myFileHandlerForFFD.put(2, new FileHandler(this, System.err));
    }

    public void outputFileOpen(JobBackendRef theJobBackend, int bfd, File file, boolean append) throws IOException {
        new FileHandler(this).outputFileOpen(theJobBackend, bfd, file, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputFileWrite(JobBackendRef theJobBackend, int ffd, int len) throws IOException {
        FileHandler handler = null;
        Map<Integer, FileHandler> map = this.myFileHandlerForFFD;
        synchronized (map) {
            handler = this.myFileHandlerForFFD.get(ffd);
        }
        if (handler != null) {
            handler.outputFileWrite(theJobBackend, ffd, len);
        } else {
            theJobBackend.outputFileWriteResult(this.myJobFrontend, ffd, new IOException("File closed, ffd=" + ffd));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputFileFlush(JobBackendRef theJobBackend, int ffd) throws IOException {
        FileHandler handler = null;
        Map<Integer, FileHandler> map = this.myFileHandlerForFFD;
        synchronized (map) {
            handler = this.myFileHandlerForFFD.get(ffd);
        }
        if (handler != null) {
            handler.outputFileFlush(theJobBackend, ffd);
        } else {
            theJobBackend.outputFileFlushResult(this.myJobFrontend, ffd, new IOException("File closed, ffd=" + ffd));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputFileClose(JobBackendRef theJobBackend, int ffd) throws IOException {
        FileHandler handler = null;
        Map<Integer, FileHandler> map = this.myFileHandlerForFFD;
        synchronized (map) {
            handler = this.myFileHandlerForFFD.get(ffd);
        }
        if (handler != null) {
            handler.outputFileClose(theJobBackend, ffd);
        } else {
            theJobBackend.outputFileCloseResult(this.myJobFrontend, ffd, new IOException("File closed, ffd=" + ffd));
        }
    }

    private class FileHandler
    extends Thread {
        private LinkedBlockingQueue<Invocation> myQueue;
        private OutputStream myOutputStream;
        private byte[] myByteArray;
        private ByteBuf myByteBuf;
        final /* synthetic */ FrontendFileWriter this$0;

        public FileHandler(FrontendFileWriter frontendFileWriter) {
            FrontendFileWriter frontendFileWriter2 = frontendFileWriter;
            Objects.requireNonNull(frontendFileWriter2);
            this.this$0 = frontendFileWriter2;
            this.myQueue = new LinkedBlockingQueue();
            this.myByteArray = new byte[0];
            this.myByteBuf = ByteBuf.buffer(this.myByteArray);
            this.setDaemon(true);
            this.start();
        }

        public FileHandler(FrontendFileWriter frontendFileWriter, OutputStream theOutputStream) {
            FrontendFileWriter frontendFileWriter2 = frontendFileWriter;
            Objects.requireNonNull(frontendFileWriter2);
            this.this$0 = frontendFileWriter2;
            this.myQueue = new LinkedBlockingQueue();
            this.myByteArray = new byte[0];
            this.myByteBuf = ByteBuf.buffer(this.myByteArray);
            this.myOutputStream = theOutputStream;
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            try {
                while (this.myQueue.take().invoke()) {
                }
            }
            catch (Throwable exc) {
                this.this$0.myJobFrontend.terminateCancelJobOther(exc);
            }
        }

        public void outputFileOpen(JobBackendRef theJobBackend, int bfd, File file, boolean append) {
            this.myQueue.offer(new OutputFileOpenInvocation(this, theJobBackend, bfd, file, append));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean invokeOutputFileOpen(JobBackendRef theJobBackend, int bfd, File file, boolean append) throws IOException {
            int ffd = 0;
            IOException result = null;
            boolean more = false;
            try {
                this.myOutputStream = new FileOutputStream(file, append);
                Map<Integer, FileHandler> map = this.this$0.myFileHandlerForFFD;
                synchronized (map) {
                    ffd = this.this$0.myNextFFD++;
                    this.this$0.myFileHandlerForFFD.put(ffd, this);
                }
                more = true;
            }
            catch (IOException exc) {
                result = exc;
            }
            theJobBackend.outputFileOpenResult(this.this$0.myJobFrontend, bfd, ffd, result);
            return more;
        }

        public void outputFileWrite(JobBackendRef theJobBackend, int ffd, int len) {
            this.myQueue.offer(new OutputFileWriteInvocation(this, theJobBackend, ffd, len));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean invokeOutputFileWrite(JobBackendRef theJobBackend, int ffd, int len) throws IOException {
            IOException result = null;
            boolean more = false;
            try {
                if (this.myByteArray.length < len) {
                    this.myByteArray = new byte[len];
                    this.myByteBuf = ByteBuf.buffer(this.myByteArray);
                }
                ((JobBackendProxy)theJobBackend).receive(ffd, this.myByteBuf);
                this.myOutputStream.write(this.myByteArray, 0, len);
                more = true;
            }
            catch (IOException exc) {
                result = exc;
                try {
                    this.myOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Map<Integer, FileHandler> map = this.this$0.myFileHandlerForFFD;
                synchronized (map) {
                    this.this$0.myFileHandlerForFFD.remove(ffd);
                }
            }
            theJobBackend.outputFileWriteResult(this.this$0.myJobFrontend, ffd, result);
            return more;
        }

        public void outputFileFlush(JobBackendRef theJobBackend, int ffd) {
            this.myQueue.offer(new OutputFileFlushInvocation(this, theJobBackend, ffd));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean invokeOutputFileFlush(JobBackendRef theJobBackend, int ffd) throws IOException {
            IOException result = null;
            boolean more = false;
            try {
                this.myOutputStream.flush();
                more = true;
            }
            catch (IOException exc) {
                result = exc;
                try {
                    this.myOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Map<Integer, FileHandler> map = this.this$0.myFileHandlerForFFD;
                synchronized (map) {
                    this.this$0.myFileHandlerForFFD.remove(ffd);
                }
            }
            theJobBackend.outputFileFlushResult(this.this$0.myJobFrontend, ffd, result);
            return more;
        }

        public void outputFileClose(JobBackendRef theJobBackend, int ffd) {
            this.myQueue.offer(new OutputFileCloseInvocation(this, theJobBackend, ffd));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean invokeOutputFileClose(JobBackendRef theJobBackend, int ffd) throws IOException {
            IOException result = null;
            try {
                this.myOutputStream.close();
            }
            catch (IOException exc) {
                result = exc;
            }
            Map<Integer, FileHandler> map = this.this$0.myFileHandlerForFFD;
            synchronized (map) {
                this.this$0.myFileHandlerForFFD.remove(ffd);
            }
            theJobBackend.outputFileCloseResult(this.this$0.myJobFrontend, ffd, result);
            return false;
        }

        private static abstract class Invocation {
            private Invocation() {
            }

            public abstract boolean invoke() throws IOException;
        }

        private class OutputFileOpenInvocation
        extends Invocation {
            private JobBackendRef theJobBackend;
            private int bfd;
            private File file;
            private boolean append;
            final /* synthetic */ FileHandler this$1;

            public OutputFileOpenInvocation(FileHandler fileHandler, JobBackendRef theJobBackend, int bfd, File file, boolean append) {
                FileHandler fileHandler2 = fileHandler;
                Objects.requireNonNull(fileHandler2);
                this.this$1 = fileHandler2;
                this.theJobBackend = theJobBackend;
                this.bfd = bfd;
                this.file = file;
                this.append = append;
            }

            @Override
            public boolean invoke() throws IOException {
                return this.this$1.invokeOutputFileOpen(this.theJobBackend, this.bfd, this.file, this.append);
            }
        }

        private class OutputFileWriteInvocation
        extends Invocation {
            private JobBackendRef theJobBackend;
            private int ffd;
            private int len;
            final /* synthetic */ FileHandler this$1;

            public OutputFileWriteInvocation(FileHandler fileHandler, JobBackendRef theJobBackend, int ffd, int len) {
                FileHandler fileHandler2 = fileHandler;
                Objects.requireNonNull(fileHandler2);
                this.this$1 = fileHandler2;
                this.theJobBackend = theJobBackend;
                this.ffd = ffd;
                this.len = len;
            }

            @Override
            public boolean invoke() throws IOException {
                return this.this$1.invokeOutputFileWrite(this.theJobBackend, this.ffd, this.len);
            }
        }

        private class OutputFileFlushInvocation
        extends Invocation {
            private JobBackendRef theJobBackend;
            private int ffd;
            final /* synthetic */ FileHandler this$1;

            public OutputFileFlushInvocation(FileHandler fileHandler, JobBackendRef theJobBackend, int ffd) {
                FileHandler fileHandler2 = fileHandler;
                Objects.requireNonNull(fileHandler2);
                this.this$1 = fileHandler2;
                this.theJobBackend = theJobBackend;
                this.ffd = ffd;
            }

            @Override
            public boolean invoke() throws IOException {
                return this.this$1.invokeOutputFileFlush(this.theJobBackend, this.ffd);
            }
        }

        private class OutputFileCloseInvocation
        extends Invocation {
            private JobBackendRef theJobBackend;
            private int ffd;
            final /* synthetic */ FileHandler this$1;

            public OutputFileCloseInvocation(FileHandler fileHandler, JobBackendRef theJobBackend, int ffd) {
                FileHandler fileHandler2 = fileHandler;
                Objects.requireNonNull(fileHandler2);
                this.this$1 = fileHandler2;
                this.theJobBackend = theJobBackend;
                this.ffd = ffd;
            }

            @Override
            public boolean invoke() throws IOException {
                return this.this$1.invokeOutputFileClose(this.theJobBackend, this.ffd);
            }
        }
    }
}

