/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontend;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;

public class FrontendFileReader {
    private JobFrontend myJobFrontend;
    private Map<Integer, FileHandler> myFileHandlerForFFD = new HashMap<Integer, FileHandler>();
    private int myNextFFD = 2;

    public FrontendFileReader(JobFrontend theJobFrontend) {
        this.myJobFrontend = theJobFrontend;
        this.myFileHandlerForFFD.put(1, new FileHandler(this, System.in));
    }

    public void inputFileOpen(JobBackendRef theJobBackend, int bfd, File file) throws IOException {
        new FileHandler(this).inputFileOpen(theJobBackend, bfd, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputFileRead(JobBackendRef theJobBackend, int ffd, int len) throws IOException {
        FileHandler handler = null;
        Map<Integer, FileHandler> map = this.myFileHandlerForFFD;
        synchronized (map) {
            handler = this.myFileHandlerForFFD.get(ffd);
        }
        if (handler != null) {
            handler.inputFileRead(theJobBackend, ffd, len);
        } else {
            theJobBackend.inputFileReadResult(this.myJobFrontend, ffd, null, -1, new IOException("File closed, ffd=" + ffd));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputFileSkip(JobBackendRef theJobBackend, int ffd, long len) throws IOException {
        FileHandler handler = null;
        Map<Integer, FileHandler> map = this.myFileHandlerForFFD;
        synchronized (map) {
            handler = this.myFileHandlerForFFD.get(ffd);
        }
        if (handler != null) {
            handler.inputFileSkip(theJobBackend, ffd, len);
        } else {
            theJobBackend.inputFileSkipResult(this.myJobFrontend, ffd, 0L, new IOException("File closed, ffd=" + ffd));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputFileClose(JobBackendRef theJobBackend, int ffd) throws IOException {
        FileHandler handler = null;
        Map<Integer, FileHandler> map = this.myFileHandlerForFFD;
        synchronized (map) {
            handler = this.myFileHandlerForFFD.get(ffd);
        }
        if (handler != null) {
            handler.inputFileClose(theJobBackend, ffd);
        } else {
            theJobBackend.inputFileCloseResult(this.myJobFrontend, ffd, new IOException("File closed, ffd=" + ffd));
        }
    }

    private class FileHandler
    extends Thread {
        private LinkedBlockingQueue<Invocation> myQueue;
        private InputStream myInputStream;
        private byte[] myBuffer;
        final /* synthetic */ FrontendFileReader this$0;

        public FileHandler(FrontendFileReader frontendFileReader) {
            FrontendFileReader frontendFileReader2 = frontendFileReader;
            Objects.requireNonNull(frontendFileReader2);
            this.this$0 = frontendFileReader2;
            this.myQueue = new LinkedBlockingQueue();
            this.myBuffer = new byte[0];
            this.setDaemon(true);
            this.start();
        }

        public FileHandler(FrontendFileReader frontendFileReader, InputStream theInputStream) {
            FrontendFileReader frontendFileReader2 = frontendFileReader;
            Objects.requireNonNull(frontendFileReader2);
            this.this$0 = frontendFileReader2;
            this.myQueue = new LinkedBlockingQueue();
            this.myBuffer = new byte[0];
            this.myInputStream = theInputStream;
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            try {
                while (this.myQueue.take().invoke()) {
                }
            }
            catch (Throwable exc) {
                this.this$0.myJobFrontend.terminateCancelJobOther(exc);
            }
        }

        public void inputFileOpen(JobBackendRef theJobBackend, int bfd, File file) {
            this.myQueue.offer(new InputFileOpenInvocation(this, theJobBackend, bfd, file));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean invokeInputFileOpen(JobBackendRef theJobBackend, int bfd, File file) throws IOException {
            int ffd = 0;
            IOException result = null;
            boolean more = false;
            try {
                this.myInputStream = new FileInputStream(file);
                Map<Integer, FileHandler> map = this.this$0.myFileHandlerForFFD;
                synchronized (map) {
                    ffd = this.this$0.myNextFFD++;
                    this.this$0.myFileHandlerForFFD.put(ffd, this);
                }
                more = true;
            }
            catch (IOException exc) {
                result = exc;
            }
            theJobBackend.inputFileOpenResult(this.this$0.myJobFrontend, bfd, ffd, result);
            return more;
        }

        public void inputFileRead(JobBackendRef theJobBackend, int ffd, int len) {
            this.myQueue.offer(new InputFileReadInvocation(this, theJobBackend, ffd, len));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean invokeInputFileRead(JobBackendRef theJobBackend, int ffd, int len) throws IOException {
            int resultlen = 0;
            IOException resultexc = null;
            boolean more = false;
            try {
                if (this.myBuffer.length < len) {
                    this.myBuffer = new byte[len];
                }
                resultlen = this.myInputStream.read(this.myBuffer, 0, len);
                more = true;
            }
            catch (IOException exc) {
                resultexc = exc;
                try {
                    this.myInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Map<Integer, FileHandler> map = this.this$0.myFileHandlerForFFD;
                synchronized (map) {
                    this.this$0.myFileHandlerForFFD.remove(ffd);
                }
            }
            theJobBackend.inputFileReadResult(this.this$0.myJobFrontend, ffd, this.myBuffer, resultlen, resultexc);
            return more;
        }

        public void inputFileSkip(JobBackendRef theJobBackend, int ffd, long len) {
            this.myQueue.offer(new InputFileSkipInvocation(this, theJobBackend, ffd, len));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean invokeInputFileSkip(JobBackendRef theJobBackend, int ffd, long len) throws IOException {
            long resultlen = 0L;
            IOException resultexc = null;
            boolean more = false;
            try {
                resultlen = this.myInputStream.skip(len);
                more = true;
            }
            catch (IOException exc) {
                resultexc = exc;
                try {
                    this.myInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Map<Integer, FileHandler> map = this.this$0.myFileHandlerForFFD;
                synchronized (map) {
                    this.this$0.myFileHandlerForFFD.remove(ffd);
                }
            }
            theJobBackend.inputFileSkipResult(this.this$0.myJobFrontend, ffd, resultlen, resultexc);
            return more;
        }

        public void inputFileClose(JobBackendRef theJobBackend, int ffd) {
            this.myQueue.offer(new InputFileCloseInvocation(this, theJobBackend, ffd));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean invokeInputFileClose(JobBackendRef theJobBackend, int ffd) throws IOException {
            IOException result = null;
            try {
                this.myInputStream.close();
            }
            catch (IOException exc) {
                result = exc;
            }
            Map<Integer, FileHandler> map = this.this$0.myFileHandlerForFFD;
            synchronized (map) {
                this.this$0.myFileHandlerForFFD.remove(ffd);
            }
            theJobBackend.inputFileCloseResult(this.this$0.myJobFrontend, ffd, result);
            return false;
        }

        private static abstract class Invocation {
            private Invocation() {
            }

            public abstract boolean invoke() throws IOException;
        }

        private class InputFileOpenInvocation
        extends Invocation {
            private JobBackendRef theJobBackend;
            private int bfd;
            private File file;
            final /* synthetic */ FileHandler this$1;

            public InputFileOpenInvocation(FileHandler fileHandler, JobBackendRef theJobBackend, int bfd, File file) {
                FileHandler fileHandler2 = fileHandler;
                Objects.requireNonNull(fileHandler2);
                this.this$1 = fileHandler2;
                this.theJobBackend = theJobBackend;
                this.bfd = bfd;
                this.file = file;
            }

            @Override
            public boolean invoke() throws IOException {
                return this.this$1.invokeInputFileOpen(this.theJobBackend, this.bfd, this.file);
            }
        }

        private class InputFileReadInvocation
        extends Invocation {
            private JobBackendRef theJobBackend;
            private int ffd;
            private int len;
            final /* synthetic */ FileHandler this$1;

            public InputFileReadInvocation(FileHandler fileHandler, JobBackendRef theJobBackend, int ffd, int len) {
                FileHandler fileHandler2 = fileHandler;
                Objects.requireNonNull(fileHandler2);
                this.this$1 = fileHandler2;
                this.theJobBackend = theJobBackend;
                this.ffd = ffd;
                this.len = len;
            }

            @Override
            public boolean invoke() throws IOException {
                return this.this$1.invokeInputFileRead(this.theJobBackend, this.ffd, this.len);
            }
        }

        private class InputFileSkipInvocation
        extends Invocation {
            private JobBackendRef theJobBackend;
            private int ffd;
            private long len;
            final /* synthetic */ FileHandler this$1;

            public InputFileSkipInvocation(FileHandler fileHandler, JobBackendRef theJobBackend, int ffd, long len) {
                FileHandler fileHandler2 = fileHandler;
                Objects.requireNonNull(fileHandler2);
                this.this$1 = fileHandler2;
                this.theJobBackend = theJobBackend;
                this.ffd = ffd;
                this.len = len;
            }

            @Override
            public boolean invoke() throws IOException {
                return this.this$1.invokeInputFileSkip(this.theJobBackend, this.ffd, this.len);
            }
        }

        private class InputFileCloseInvocation
        extends Invocation {
            private JobBackendRef theJobBackend;
            private int ffd;
            final /* synthetic */ FileHandler this$1;

            public InputFileCloseInvocation(FileHandler fileHandler, JobBackendRef theJobBackend, int ffd) {
                FileHandler fileHandler2 = fileHandler;
                Objects.requireNonNull(fileHandler2);
                this.this$1 = fileHandler2;
                this.theJobBackend = theJobBackend;
                this.ffd = ffd;
            }

            @Override
            public boolean invoke() throws IOException {
                return this.this$1.invokeInputFileClose(this.theJobBackend, this.ffd);
            }
        }
    }
}

