/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.io.LineBufferedOutputStream;
import edu.rit.pj.cluster.BackendFileOutputStream;
import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontendRef;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class BackendFileWriter {
    public final PrintStream out;
    public final PrintStream err;
    private JobFrontendRef myJobFrontend;
    private JobBackendRef myJobBackend;
    private Map<Integer, BackendFileOutputStream> myOutputStreamForBFD = new HashMap<Integer, BackendFileOutputStream>();
    private Map<Integer, BackendFileOutputStream> myOutputStreamForFFD = new HashMap<Integer, BackendFileOutputStream>();
    private int myNextBFD = 1;

    public BackendFileWriter(JobFrontendRef theJobFrontend, JobBackendRef theJobBackend) {
        this.myJobFrontend = theJobFrontend;
        this.myJobBackend = theJobBackend;
        BackendFileOutputStream outstream = new BackendFileOutputStream(this.myJobFrontend, this.myJobBackend, 1);
        BackendFileOutputStream errstream = new BackendFileOutputStream(this.myJobFrontend, this.myJobBackend, 2);
        this.myOutputStreamForFFD.put(1, outstream);
        this.myOutputStreamForFFD.put(2, errstream);
        this.out = new PrintStream(new LineBufferedOutputStream(outstream), true);
        this.err = new PrintStream(new LineBufferedOutputStream(errstream), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackendFileOutputStream open(File file, boolean append) throws IOException {
        BackendFileOutputStream stream = null;
        int bfd = 0;
        int ffd = 0;
        BackendFileWriter backendFileWriter = this;
        synchronized (backendFileWriter) {
            stream = new BackendFileOutputStream(this.myJobFrontend, this.myJobBackend);
            bfd = this.myNextBFD++;
            this.myOutputStreamForBFD.put(bfd, stream);
        }
        ffd = stream.open(bfd, file, append);
        backendFileWriter = this;
        synchronized (backendFileWriter) {
            this.myOutputStreamForFFD.put(ffd, stream);
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputFileOpenResult(JobFrontendRef theJobFrontend, int bfd, int ffd, IOException exc) {
        BackendFileOutputStream stream = null;
        BackendFileWriter backendFileWriter = this;
        synchronized (backendFileWriter) {
            stream = this.myOutputStreamForBFD.remove(bfd);
        }
        if (stream != null) {
            stream.putResult(ffd, exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputFileWriteResult(JobFrontendRef theJobFrontend, int ffd, IOException exc) {
        BackendFileOutputStream stream = null;
        BackendFileWriter backendFileWriter = this;
        synchronized (backendFileWriter) {
            stream = this.myOutputStreamForFFD.get(ffd);
        }
        if (stream != null) {
            stream.putResult(ffd, exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputFileFlushResult(JobFrontendRef theJobFrontend, int ffd, IOException exc) {
        BackendFileOutputStream stream = null;
        BackendFileWriter backendFileWriter = this;
        synchronized (backendFileWriter) {
            stream = this.myOutputStreamForFFD.get(ffd);
        }
        if (stream != null) {
            stream.putResult(ffd, exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputFileCloseResult(JobFrontendRef theJobFrontend, int ffd, IOException exc) {
        BackendFileOutputStream stream = null;
        BackendFileWriter backendFileWriter = this;
        synchronized (backendFileWriter) {
            stream = this.myOutputStreamForFFD.remove(ffd);
        }
        if (stream != null) {
            stream.putResult(ffd, exc);
        }
    }
}

