/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.pj.cluster.BackendFileInputStream;
import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontendRef;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class BackendFileReader {
    public final BackendFileInputStream in;
    private JobFrontendRef myJobFrontend;
    private JobBackendRef myJobBackend;
    private Map<Integer, BackendFileInputStream> myInputStreamForBFD = new HashMap<Integer, BackendFileInputStream>();
    private Map<Integer, BackendFileInputStream> myInputStreamForFFD = new HashMap<Integer, BackendFileInputStream>();
    private int myNextBFD = 1;

    public BackendFileReader(JobFrontendRef theJobFrontend, JobBackendRef theJobBackend) {
        this.myJobFrontend = theJobFrontend;
        this.myJobBackend = theJobBackend;
        this.in = new BackendFileInputStream(this.myJobFrontend, this.myJobBackend, 1);
        this.myInputStreamForFFD.put(1, this.in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackendFileInputStream open(File file) throws IOException {
        BackendFileInputStream stream = null;
        int bfd = 0;
        int ffd = 0;
        BackendFileReader backendFileReader = this;
        synchronized (backendFileReader) {
            stream = new BackendFileInputStream(this.myJobFrontend, this.myJobBackend);
            bfd = this.myNextBFD++;
            this.myInputStreamForBFD.put(bfd, stream);
        }
        ffd = stream.open(bfd, file);
        backendFileReader = this;
        synchronized (backendFileReader) {
            this.myInputStreamForFFD.put(ffd, stream);
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputFileOpenResult(JobFrontendRef theJobFrontend, int bfd, int ffd, IOException exc) {
        BackendFileInputStream stream = null;
        BackendFileReader backendFileReader = this;
        synchronized (backendFileReader) {
            stream = this.myInputStreamForBFD.remove(bfd);
        }
        if (stream != null) {
            stream.putResult(ffd, 0, 0L, exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputFileReadResult(JobFrontendRef theJobFrontend, int ffd, int len, IOException exc) {
        BackendFileInputStream stream = null;
        BackendFileReader backendFileReader = this;
        synchronized (backendFileReader) {
            stream = this.myInputStreamForFFD.get(ffd);
        }
        if (stream != null) {
            stream.putResult(ffd, len, 0L, exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputFileSkipResult(JobFrontendRef theJobFrontend, int ffd, long len, IOException exc) {
        BackendFileInputStream stream = null;
        BackendFileReader backendFileReader = this;
        synchronized (backendFileReader) {
            stream = this.myInputStreamForFFD.get(ffd);
        }
        if (stream != null) {
            stream.putResult(ffd, 0, len, exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputFileCloseResult(JobFrontendRef theJobFrontend, int ffd, IOException exc) {
        BackendFileInputStream stream = null;
        BackendFileReader backendFileReader = this;
        synchronized (backendFileReader) {
            stream = this.myInputStreamForFFD.remove(ffd);
        }
        if (stream != null) {
            stream.putResult(ffd, 0, 0L, exc);
        }
    }
}

