/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.mp.ByteBuf;
import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontendProxy;
import edu.rit.pj.cluster.JobFrontendRef;
import edu.rit.util.Range;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.concurrent.LinkedBlockingQueue;

public class BackendFileInputStream
extends InputStream {
    private JobFrontendRef myJobFrontend;
    private JobBackendRef myJobBackend;
    private LinkedBlockingQueue<Result> myResultQueue = new LinkedBlockingQueue();
    private int ffd;

    BackendFileInputStream(JobFrontendRef theJobFrontend, JobBackendRef theJobBackend) {
        this.myJobFrontend = theJobFrontend;
        this.myJobBackend = theJobBackend;
    }

    BackendFileInputStream(JobFrontendRef theJobFrontend, JobBackendRef theJobBackend, int ffd) {
        this.myJobFrontend = theJobFrontend;
        this.myJobBackend = theJobBackend;
        this.ffd = ffd;
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int len = this.read(buf);
        return len == -1 ? -1 : buf[0] & 0xFF;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > buf.length) {
            throw new IndexOutOfBoundsException();
        }
        this.verifyOpen();
        this.myJobFrontend.inputFileRead(this.myJobBackend, this.ffd, len);
        Result r = this.getResult();
        if (r.readlen > 0) {
            ((JobFrontendProxy)this.myJobFrontend).receive(this.ffd, ByteBuf.sliceBuffer(buf, new Range(off, off + len - 1)));
        }
        return r.readlen;
    }

    @Override
    public long skip(long len) throws IOException {
        this.verifyOpen();
        if (len < 0L) {
            return 0L;
        }
        this.myJobFrontend.inputFileSkip(this.myJobBackend, this.ffd, len);
        return this.getResult().skiplen;
    }

    @Override
    public void close() throws IOException {
        this.verifyOpen();
        try {
            this.myJobFrontend.inputFileClose(this.myJobBackend, this.ffd);
            this.getResult();
        }
        finally {
            this.ffd = 0;
        }
    }

    int open(int bfd, File file) throws IOException {
        this.myJobFrontend.inputFileOpen(this.myJobBackend, bfd, file);
        this.ffd = this.getResult().ffd;
        return this.ffd;
    }

    private Result getResult() throws IOException {
        try {
            Result result = this.myResultQueue.take();
            if (result.exc != null) {
                throw result.exc;
            }
            return result;
        }
        catch (InterruptedException exc) {
            InterruptedIOException exc2 = new InterruptedIOException("I/O interrupted");
            exc2.initCause(exc);
            throw exc2;
        }
    }

    void putResult(int ffd, int readlen, long skiplen, IOException exc) {
        this.myResultQueue.offer(new Result(ffd, readlen, skiplen, exc));
    }

    private void verifyOpen() throws IOException {
        if (this.ffd == 0) {
            throw new IOException("File closed");
        }
    }

    private static class Result {
        public int ffd;
        public int readlen;
        public long skiplen;
        public IOException exc;

        public Result(int ffd, int readlen, long skiplen, IOException exc) {
            this.ffd = ffd;
            this.readlen = readlen;
            this.skiplen = skiplen;
            this.exc = exc;
        }
    }
}

