/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.Comm;
import edu.rit.pj.MultipleParallelException;
import edu.rit.pj.WorkerRegion;
import edu.rit.pj.WorkerTeamThread;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;

public class WorkerTeam {
    int K;
    Comm comm;
    int size;
    int rank;
    int count;
    WorkerTeamThread[] myThread;
    WorkerRegion myRegion;
    Semaphore myRegionEndSemaphore = new Semaphore(0);
    ConcurrentHashMap<Integer, Throwable> myExceptionMap;

    WorkerTeam(boolean flag) {
    }

    public WorkerTeam() {
        this(Comm.world());
    }

    public WorkerTeam(Comm comm) {
        if (comm == null) {
            throw new NullPointerException("WorkerTeam(): comm is null");
        }
        this.initialize(1, comm, comm.size(), comm.rank(), comm.size(), comm.rank());
    }

    void initialize(int K, Comm comm, int size, int rank, int count, int wlb) {
        this.K = K;
        this.comm = comm;
        this.size = size;
        this.rank = rank;
        this.count = count;
        int WM = K + (rank == 0 ? 1 : 0);
        this.myThread = new WorkerTeamThread[WM];
        for (int i = 0; i < K; ++i) {
            this.myThread[i] = new WorkerTeamThread(this, wlb + i);
        }
        if (WM > K) {
            this.myThread[K] = new WorkerTeamThread(this, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(WorkerRegion theRegion) throws Exception {
        if (theRegion == null) {
            throw new NullPointerException("WorkerTeam.execute(): theRegion is null");
        }
        if (this.myRegion != null) {
            throw new IllegalStateException("WorkerTeam.execute(): Already executing a worker region");
        }
        if (theRegion.myTeam != null) {
            throw new IllegalStateException("WorkerTeam.execute(): theRegion already being executed by a worker team");
        }
        this.myRegion = theRegion;
        this.myExceptionMap = new ConcurrentHashMap(this.K, 0.75f, this.K);
        theRegion.myTeam = this;
        try {
            this.myRegion.start();
            for (WorkerTeamThread thread : this.myThread) {
                thread.myRegionBeginSemaphore.release();
            }
            this.myRegionEndSemaphore.acquireUninterruptibly(this.myThread.length);
            if (!this.myExceptionMap.isEmpty()) {
                if (this.myExceptionMap.size() == 1) {
                    WorkerTeam.rethrow(this.myExceptionMap.values().iterator().next());
                } else {
                    throw new MultipleParallelException("WorkerTeam.execute(): Multiple threads threw exceptions", this.myExceptionMap);
                }
            }
            this.myRegion.finish();
        }
        finally {
            this.myRegion.myTeam = null;
            this.myExceptionMap = null;
            this.myRegion = null;
        }
    }

    public final boolean isExecutingInParallel() {
        return this.myRegion != null;
    }

    public final WorkerRegion region() {
        if (this.myRegion == null) {
            throw new IllegalStateException("WorkerTeam.region(): Not executing a worker region");
        }
        return this.myRegion;
    }

    public final int getThreadCount() {
        return this.K;
    }

    public final int getTotalThreadCount() {
        return this.count;
    }

    public int masterRank() {
        return 0;
    }

    public int workerRank(int w) {
        if (0 > w || w >= this.count) {
            throw new IllegalArgumentException("WorkerTeam.workerRank(): w (= " + w + ") illegal");
        }
        return w;
    }

    static void rethrow(Object exc) throws Exception {
        if (exc instanceof RuntimeException) {
            throw (RuntimeException)exc;
        }
        if (exc instanceof Exception) {
            throw (Exception)exc;
        }
        if (exc instanceof Error) {
            throw (Error)exc;
        }
    }
}

