/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.ArrayItemGenerator;
import edu.rit.pj.IteratorItemGenerator;
import edu.rit.pj.WorkerConstruct;
import edu.rit.pj.WorkerIntegerForLoop;
import edu.rit.pj.WorkerIntegerStrideForLoop;
import edu.rit.pj.WorkerIteration;
import edu.rit.pj.WorkerLongForLoop;
import edu.rit.pj.WorkerLongStrideForLoop;
import edu.rit.pj.WorkerTeamThread;
import edu.rit.util.LongRange;
import edu.rit.util.Range;
import java.util.Iterator;

public abstract class WorkerRegion
extends WorkerConstruct {
    public void start() throws Exception {
    }

    public abstract void run() throws Exception;

    public void finish() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(int first, int last, WorkerIntegerForLoop theLoop) throws Exception {
        if (theLoop == null) {
            throw new NullPointerException("WorkerRegion.execute(): Worker for loop is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("WorkerRegion.execute(): No parallel team executing");
        }
        try {
            theLoop.myTeam = this.myTeam;
            WorkerTeamThread currentThread = this.getCurrentThread();
            int w = currentThread.myIndex;
            Range range = new Range(first, last);
            if (w == -1) {
                theLoop.masterExecute(range);
            } else {
                theLoop.workerExecute(w, range);
            }
        }
        finally {
            theLoop.myTeam = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(int first, int last, int stride, WorkerIntegerStrideForLoop theLoop) throws Exception {
        if (stride <= 0) {
            throw new IllegalArgumentException("WorkerRegion.execute(): Stride = " + stride + " illegal");
        }
        if (theLoop == null) {
            throw new NullPointerException("WorkerRegion.execute(): Worker for loop is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("WorkerRegion.execute(): No parallel team executing");
        }
        try {
            theLoop.myTeam = this.myTeam;
            WorkerTeamThread currentThread = this.getCurrentThread();
            int w = currentThread.myIndex;
            Range range = new Range(first, last, stride);
            if (w == -1) {
                theLoop.masterExecute(range);
            } else {
                theLoop.workerExecute(w, range);
            }
        }
        finally {
            theLoop.myTeam = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(long first, long last, WorkerLongForLoop theLoop) throws Exception {
        if (theLoop == null) {
            throw new NullPointerException("WorkerRegion.execute(): Worker for loop is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("WorkerRegion.execute(): No parallel team executing");
        }
        try {
            theLoop.myTeam = this.myTeam;
            WorkerTeamThread currentThread = this.getCurrentThread();
            int w = currentThread.myIndex;
            LongRange range = new LongRange(first, last);
            if (w == -1) {
                theLoop.masterExecute(range);
            } else {
                theLoop.workerExecute(w, range);
            }
        }
        finally {
            theLoop.myTeam = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(long first, long last, long stride, WorkerLongStrideForLoop theLoop) throws Exception {
        if (stride <= 0L) {
            throw new IllegalArgumentException("WorkerRegion.execute(): Stride = " + stride + " illegal");
        }
        if (theLoop == null) {
            throw new NullPointerException("WorkerRegion.execute(): Worker for loop is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("WorkerRegion.execute(): No parallel team executing");
        }
        try {
            theLoop.myTeam = this.myTeam;
            WorkerTeamThread currentThread = this.getCurrentThread();
            int w = currentThread.myIndex;
            LongRange range = new LongRange(first, last, stride);
            if (w == -1) {
                theLoop.masterExecute(range);
            } else {
                theLoop.workerExecute(w, range);
            }
        }
        finally {
            theLoop.myTeam = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void execute(T[] theArray, WorkerIteration<T> theIteration) throws Exception {
        if (this.myTeam == null) {
            throw new IllegalStateException("WorkerRegion.execute(): No parallel team executing");
        }
        if (this.myTeam.rank == this.myTeam.masterRank() && theArray == null) {
            throw new NullPointerException("WorkerRegion.execute(): Array is null");
        }
        if (theIteration == null) {
            throw new NullPointerException("WorkerRegion.execute(): Worker iteration is null");
        }
        try {
            theIteration.myTeam = this.myTeam;
            WorkerTeamThread currentThread = this.getCurrentThread();
            int w = currentThread.myIndex;
            if (w == -1) {
                theIteration.masterExecute(new ArrayItemGenerator<T>(theArray));
            } else {
                theIteration.workerExecute(w);
            }
        }
        finally {
            theIteration.myTeam = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void execute(Iterator<T> theIterator, WorkerIteration<T> theIteration) throws Exception {
        if (this.myTeam == null) {
            throw new IllegalStateException("WorkerRegion.execute(): No parallel team executing");
        }
        if (this.myTeam.rank == this.myTeam.masterRank() && theIterator == null) {
            throw new NullPointerException("WorkerRegion.execute(): Iterator is null");
        }
        if (theIteration == null) {
            throw new NullPointerException("WorkerRegion.execute(): Worker iteration is null");
        }
        try {
            theIteration.myTeam = this.myTeam;
            WorkerTeamThread currentThread = this.getCurrentThread();
            int w = currentThread.myIndex;
            if (w == -1) {
                theIteration.masterExecute(new IteratorItemGenerator<T>(theIterator));
            } else {
                theIteration.workerExecute(w);
            }
        }
        finally {
            theIteration.myTeam = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void execute(Iterable<T> theIterable, WorkerIteration<T> theIteration) throws Exception {
        if (this.myTeam == null) {
            throw new IllegalStateException("WorkerRegion.execute(): No parallel team executing");
        }
        if (this.myTeam.rank == this.myTeam.masterRank() && theIterable == null) {
            throw new NullPointerException("WorkerRegion.execute(): Iterable collection is null");
        }
        if (theIteration == null) {
            throw new NullPointerException("WorkerRegion.execute(): Worker iteration is null");
        }
        try {
            theIteration.myTeam = this.myTeam;
            WorkerTeamThread currentThread = this.getCurrentThread();
            int w = currentThread.myIndex;
            if (w == -1) {
                theIteration.masterExecute(new IteratorItemGenerator<T>(theIterable.iterator()));
            } else {
                theIteration.workerExecute(w);
            }
        }
        finally {
            theIteration.myTeam = null;
        }
    }
}

