/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.mp.ObjectBuf;
import edu.rit.mp.buf.ObjectItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.CommStatus;
import edu.rit.pj.ItemGenerator;
import edu.rit.pj.ItemHolder;
import edu.rit.pj.WorkerConstruct;
import edu.rit.pj.WorkerTeam;
import edu.rit.util.Range;
import java.io.IOException;

public abstract class WorkerIteration<T>
extends WorkerConstruct {
    public void start() throws Exception {
    }

    public void sendTaskInput(T item, Comm comm, int wRank, int tag) throws IOException {
    }

    public void receiveTaskInput(T item, Comm comm, int mRank, int tag) throws IOException {
    }

    public abstract void run(T var1) throws Exception;

    public void sendTaskOutput(T item, Comm comm, int mRank, int tag) throws IOException {
    }

    public void receiveTaskOutput(T item, Comm comm, int wRank, int tag) throws IOException {
    }

    public void finish() throws Exception {
    }

    public int tagOffset() {
        return Integer.MIN_VALUE;
    }

    void masterExecute(ItemGenerator<T> generator) throws IOException {
        int tag;
        int r;
        ItemHolder<T> holder;
        int count;
        int remaining = count = this.myTeam.count;
        ObjectItemBuf buf = ObjectBuf.buffer();
        Range tagRange = new Range(this.tagFor(0), this.tagFor(count - 1));
        Comm comm = this.myTeam.comm;
        for (int w = 0; w < count; ++w) {
            holder = generator.nextItem();
            buf.item = holder;
            buf.reset();
            r = this.myTeam.workerRank(w);
            tag = this.tagFor(w);
            comm.send(r, tag, buf);
            if (holder == null) {
                --remaining;
                continue;
            }
            this.sendTaskInput(holder.myItem, comm, r, tag);
        }
        while (remaining > 0) {
            CommStatus status = comm.receive(null, tagRange, buf);
            holder = (ItemHolder<T>)buf.item;
            r = status.fromRank;
            tag = status.tag;
            int w = this.workerFor(tag);
            this.receiveTaskOutput(holder.myItem, comm, r, tag);
            holder = generator.nextItem();
            buf.item = holder;
            buf.reset();
            comm.send(r, tag, buf);
            if (holder == null) {
                --remaining;
                continue;
            }
            this.sendTaskInput(holder.myItem, comm, r, tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void workerExecute(int w) throws Exception {
        Comm comm = this.myTeam.comm;
        int r = this.myTeam.masterRank();
        int tag = this.tagFor(w);
        this.start();
        ObjectItemBuf buf = ObjectBuf.buffer();
        while (true) {
            comm.receive((Integer)r, tag, buf);
            ItemHolder holder = (ItemHolder)buf.item;
            if (holder == null) break;
            this.receiveTaskInput(holder.myItem, comm, r, tag);
            this.run(holder.myItem);
            buf.reset();
            WorkerTeam workerTeam = this.myTeam;
            synchronized (workerTeam) {
                comm.send(r, tag, buf);
                this.sendTaskOutput(holder.myItem, comm, r, tag);
            }
        }
        this.finish();
    }

    private int tagFor(int w) {
        return w + this.tagOffset();
    }

    private int workerFor(int tag) {
        return tag - this.tagOffset();
    }
}

