/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.BarrierAction;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ItemGenerator;
import edu.rit.pj.KillRegion;
import edu.rit.pj.LongSchedule;
import edu.rit.pj.PJProperties;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.Spinner;
import edu.rit.pj.reduction.SharedLong;
import java.io.PrintStream;
import java.util.concurrent.Semaphore;

class ParallelTeamThread
implements Runnable {
    ParallelTeam myTeam;
    int myIndex;
    Semaphore myRegionBeginSemaphore = new Semaphore(0);
    volatile int myBarrierFlag;
    volatile int myConstructCount;
    volatile IntegerSchedule myIntegerSchedule;
    volatile LongSchedule myLongSchedule;
    volatile ItemGenerator<?> myItemGenerator;
    volatile Throwable myConstructException;
    private final Thread thread;
    public static SharedLong totalThreads = new SharedLong(0L);
    private long p0;
    private long p1;
    private long p2;
    private long p3;
    private long p4;
    private long p5;
    private long p6;
    private long p7;
    private long p8;
    private long p9;
    private long pa;
    private long pb;
    private long pc;
    private long pd;
    private long pe;
    private long pf;

    public ParallelTeamThread(ParallelTeam theTeam, int theIndex) {
        this.myTeam = theTeam;
        this.myIndex = theIndex;
        String name = "ParallelTeamThread-" + theIndex;
        boolean isVirtual = PJProperties.getPjVt();
        if (isVirtual) {
            this.thread = Thread.ofVirtual().name(name).unstarted(this);
        } else {
            this.thread = Thread.ofPlatform().name(name).unstarted(this);
            this.thread.setDaemon(true);
        }
        long numThreads = totalThreads.incrementAndGet();
        this.thread.start();
    }

    public Thread getThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            this.myRegionBeginSemaphore.acquireUninterruptibly();
            if (this.myTeam.myRegion instanceof KillRegion) {
                try {
                    this.myTeam.myRegion.run();
                }
                catch (Exception ex) {
                    System.err.printf("Error exiting parallel team thread: %s%n", ex);
                }
                break;
            }
            try {
                this.myTeam.myRegion.run();
            }
            catch (Throwable exc) {
                PrintStream printStream = System.err;
                synchronized (printStream) {
                    System.err.println("Parallel team thread " + this.myIndex + ": ParallelRegion.run() threw an exception");
                    exc.printStackTrace(System.err);
                    if (exc.getCause() != null) {
                        exc.getCause().printStackTrace(System.err);
                    }
                }
                this.myTeam.myExceptionMap.put(this.myIndex, exc);
            }
            this.myTeam.myRegionEndSemaphore.release();
        }
        this.myTeam.myRegionEndSemaphore.release();
    }

    void barrier() {
        int newBarrierFlag;
        this.myBarrierFlag = newBarrierFlag = this.myTeam.myBarrierFlag ^ 1;
        if (this.myTeam.myBarrierFlag != newBarrierFlag) {
            Spinner spinner = new Spinner();
            while (this.myTeam.myBarrierFlag != newBarrierFlag) {
                spinner.spin();
            }
        }
    }

    void barrier(BarrierAction action) throws Exception {
        this.barrier();
    }

    boolean arriveAtParallelConstruct() {
        int oldConstructCount;
        int K = this.myTeam.K;
        for (int i = 0; i < K; ++i) {
            ParallelTeamThread thread_i = this.myTeam.myThread[i];
            if (thread_i.myConstructCount >= this.myConstructCount) continue;
            Spinner spinner = new Spinner();
            while (thread_i.myConstructCount < this.myConstructCount) {
                spinner.spin();
            }
        }
        do {
            if ((oldConstructCount = this.myTeam.myConstructCount.get()) == this.myConstructCount) continue;
            this.myConstructCount = oldConstructCount;
            return false;
        } while (!this.myTeam.myConstructCount.compareAndSet(oldConstructCount, oldConstructCount + 1));
        this.myConstructCount = oldConstructCount + 1;
        return true;
    }

    void setIntegerSchedule(IntegerSchedule theSchedule) {
        if (this.myIntegerSchedule != null) {
            Spinner spinner = new Spinner();
            while (this.myIntegerSchedule != null) {
                spinner.spin();
            }
        }
        this.myIntegerSchedule = theSchedule;
    }

    IntegerSchedule getIntegerSchedule() throws Exception {
        if (this.myIntegerSchedule == null && this.myConstructException == null) {
            Spinner spinner = new Spinner();
            while (this.myIntegerSchedule == null && this.myConstructException == null) {
                spinner.spin();
            }
        }
        IntegerSchedule schedule = this.myIntegerSchedule;
        this.myIntegerSchedule = null;
        Throwable exc = this.myConstructException;
        this.myConstructException = null;
        ParallelTeam.rethrow(exc);
        return schedule;
    }

    void setLongSchedule(LongSchedule theSchedule) {
        if (this.myLongSchedule != null) {
            Spinner spinner = new Spinner();
            while (this.myLongSchedule != null) {
                spinner.spin();
            }
        }
        this.myLongSchedule = theSchedule;
    }

    LongSchedule getLongSchedule() throws Exception {
        if (this.myLongSchedule == null && this.myConstructException == null) {
            Spinner spinner = new Spinner();
            while (this.myLongSchedule == null && this.myConstructException == null) {
                spinner.spin();
            }
        }
        LongSchedule schedule = this.myLongSchedule;
        this.myLongSchedule = null;
        Throwable exc = this.myConstructException;
        this.myConstructException = null;
        ParallelTeam.rethrow(exc);
        return schedule;
    }

    void setItemGenerator(ItemGenerator<?> theItemGenerator) {
        if (this.myItemGenerator != null) {
            Spinner spinner = new Spinner();
            while (this.myItemGenerator != null) {
                spinner.spin();
            }
        }
        this.myItemGenerator = theItemGenerator;
    }

    ItemGenerator<?> getItemGenerator() throws Exception {
        if (this.myItemGenerator == null && this.myConstructException == null) {
            Spinner spinner = new Spinner();
            while (this.myItemGenerator == null && this.myConstructException == null) {
                spinner.spin();
            }
        }
        ItemGenerator<?> generator = this.myItemGenerator;
        this.myItemGenerator = null;
        Throwable exc = this.myConstructException;
        this.myConstructException = null;
        ParallelTeam.rethrow(exc);
        return generator;
    }

    void setConstructException(Throwable theException) {
        if (this.myConstructException != null) {
            Spinner spinner = new Spinner();
            while (this.myConstructException != null) {
                spinner.spin();
            }
        }
        this.myConstructException = theException;
    }
}

