/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.BarrierAction;
import edu.rit.pj.KillRegion;
import edu.rit.pj.MultipleParallelException;
import edu.rit.pj.PJProperties;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeamThread;
import edu.rit.pj.ParallelTeamThread_0;
import edu.rit.pj.Spinner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;

public class ParallelTeam {
    int K;
    ParallelTeamThread[] myThread;
    ParallelRegion myRegion;
    Semaphore myRegionEndSemaphore = new Semaphore(0);
    ConcurrentHashMap<Integer, Throwable> myExceptionMap;
    volatile int myBarrierFlag;
    AtomicInteger myConstructCount = new AtomicInteger(0);
    boolean isActive = true;

    public ParallelTeam() {
        this(ParallelTeam.getDefaultThreadCount());
    }

    public ParallelTeam(int K) {
        if (K < 1) {
            throw new IllegalArgumentException("ParallelTeam(): K must be >= 1");
        }
        this.K = K;
        this.myThread = new ParallelTeamThread[K];
        this.myThread[0] = new ParallelTeamThread_0(this, 0);
        for (int i = 1; i < K; ++i) {
            this.myThread[i] = new ParallelTeamThread(this, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(ParallelRegion theRegion) throws Exception {
        if (theRegion == null) {
            throw new NullPointerException("ParallelTeam.execute(): theRegion is null");
        }
        if (this.myRegion != null) {
            throw new IllegalStateException("ParallelTeam.execute(): Already executing a parallel region");
        }
        if (theRegion.myTeam != null) {
            throw new IllegalStateException("ParallelTeam.execute(): theRegion already being executed by a parallel team");
        }
        if (!this.isActive) {
            throw new IllegalStateException("ParallelTeam.execute(): The team has been shut down.");
        }
        this.myRegion = theRegion;
        this.myExceptionMap = new ConcurrentHashMap(this.K, 0.75f, this.K);
        theRegion.myTeam = this;
        try {
            this.myRegion.start();
            for (ParallelTeamThread thread : this.myThread) {
                thread.myRegionBeginSemaphore.release();
            }
            this.myRegionEndSemaphore.acquireUninterruptibly(this.K);
            if (!this.myExceptionMap.isEmpty()) {
                if (this.myExceptionMap.size() == 1) {
                    ParallelTeam.rethrow(this.myExceptionMap.values().iterator().next());
                } else {
                    throw new MultipleParallelException("ParallelTeam.execute(): Multiple threads threw exceptions", this.myExceptionMap);
                }
            }
            this.myRegion.finish();
        }
        finally {
            this.myRegion.myTeam = null;
            this.myExceptionMap = null;
            this.myRegion = null;
        }
    }

    public final boolean isExecutingInParallel() {
        return this.myRegion != null;
    }

    public final ParallelRegion region() {
        if (this.myRegion == null) {
            throw new IllegalStateException("ParallelTeam.region(): Not executing a parallel region");
        }
        return this.myRegion;
    }

    public final int getThreadCount() {
        return this.K;
    }

    public static int getDefaultThreadCount() {
        int k = PJProperties.getPjNt();
        if (k == 0) {
            k = Runtime.getRuntime().availableProcessors();
        }
        return k;
    }

    void barrier() {
        int newBarrierFlag = this.myBarrierFlag ^ 1;
        for (int i = 1; i < this.K; ++i) {
            ParallelTeamThread thread_i = this.myThread[i];
            if (thread_i.myBarrierFlag == newBarrierFlag) continue;
            Spinner spinner = new Spinner();
            while (thread_i.myBarrierFlag != newBarrierFlag) {
                spinner.spin();
            }
        }
        this.myBarrierFlag = newBarrierFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void barrier(BarrierAction action) throws Exception {
        int newBarrierFlag = this.myBarrierFlag ^ 1;
        for (int i = 1; i < this.K; ++i) {
            ParallelTeamThread thread_i = this.myThread[i];
            if (thread_i.myBarrierFlag == newBarrierFlag) continue;
            Spinner spinner = new Spinner();
            while (thread_i.myBarrierFlag != newBarrierFlag) {
                spinner.spin();
            }
        }
        try {
            action.myTeam = this;
            action.run();
        }
        finally {
            action.myTeam = null;
            this.myBarrierFlag = newBarrierFlag;
        }
    }

    static void rethrow(Object exc) throws Exception {
        if (exc instanceof RuntimeException) {
            throw (RuntimeException)exc;
        }
        if (exc instanceof Exception) {
            throw (Exception)exc;
        }
        if (exc instanceof Error) {
            throw (Error)exc;
        }
    }

    public void shutdown() throws Exception {
        if (this.isActive) {
            this.execute(new KillRegion());
            this.isActive = false;
        }
    }
}

