/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.ItemGenerator;
import edu.rit.pj.ParallelConstruct;
import edu.rit.pj.ParallelSection;
import edu.rit.pj.Spinner;

public abstract class ParallelIteration<T>
extends ParallelConstruct {
    ItemGenerator<T> myItemGenerator;
    int myOrderedIndex;

    public void start() throws Exception {
    }

    public abstract void run(T var1) throws Exception;

    public void finish() throws Exception {
    }

    public final void ordered(ParallelSection theSection) throws Exception {
        if (theSection == null) {
            throw new IllegalStateException("ParallelIteration.ordered(): Parallel section is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelIteration.ordered(): No parallel team executing");
        }
        if (this.myItemGenerator.myOrderedIndex != this.myOrderedIndex) {
            Spinner spinner = new Spinner();
            while (this.myItemGenerator.myOrderedIndex != this.myOrderedIndex) {
                spinner.spin();
            }
        }
        theSection.myTeam = this.myTeam;
        try {
            theSection.run();
        }
        finally {
            theSection.myTeam = null;
            ++this.myOrderedIndex;
            this.myItemGenerator.myOrderedIndex = this.myOrderedIndex;
        }
    }

    public final void stopLoop() {
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelIteration.stopLoop(): No parallel team executing");
        }
        this.myItemGenerator.myBreak = true;
    }

    void commonRun(int index, T item) throws Exception {
        this.myOrderedIndex = index;
        this.run(item);
    }
}

