/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.DynamicIntegerSchedule;
import edu.rit.pj.FixedIntegerSchedule;
import edu.rit.pj.GuidedIntegerSchedule;
import edu.rit.pj.PJProperties;
import edu.rit.pj.Schedule;
import edu.rit.util.Range;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class IntegerSchedule
extends Schedule {
    volatile int myOrderedIndex;

    protected IntegerSchedule() {
    }

    public static IntegerSchedule fixed() {
        return new FixedIntegerSchedule();
    }

    public static IntegerSchedule dynamic() {
        return new DynamicIntegerSchedule(1);
    }

    public static IntegerSchedule dynamic(int theChunkSize) {
        return new DynamicIntegerSchedule(theChunkSize);
    }

    public static IntegerSchedule guided() {
        return new GuidedIntegerSchedule(1);
    }

    public static IntegerSchedule guided(int theChunkSize) {
        return new GuidedIntegerSchedule(theChunkSize);
    }

    public static IntegerSchedule runtime() {
        return IntegerSchedule.runtime(IntegerSchedule.fixed());
    }

    public static IntegerSchedule runtime(IntegerSchedule defaultSchedule) {
        String s = PJProperties.getPjSchedule();
        return s == null ? defaultSchedule : IntegerSchedule.parse(s);
    }

    public static IntegerSchedule parse(String s) {
        try {
            int p1 = s.indexOf(40);
            if (p1 == -1) {
                Class<?> subclass = Class.forName(IntegerSchedule.getSubclassName(s), true, Thread.currentThread().getContextClassLoader());
                return (IntegerSchedule)subclass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            int p2 = s.indexOf(41);
            if (p2 != s.length() - 1) {
                throw new IllegalArgumentException("IntegerSchedule.parse(): Schedule \"" + s + "\" illegal");
            }
            String[] args = s.substring(p1 + 1, p2).split(",");
            Class<?> subclass = Class.forName(IntegerSchedule.getSubclassName(s.substring(0, p1)), true, Thread.currentThread().getContextClassLoader());
            Constructor<?> constructor = subclass.getConstructor(String[].class);
            return (IntegerSchedule)constructor.newInstance(new Object[]{args});
        }
        catch (ClassCastException exc) {
            throw new IllegalArgumentException("IntegerSchedule.parse(): Schedule \"" + s + "\" illegal", exc);
        }
        catch (ClassNotFoundException exc) {
            throw new IllegalArgumentException("IntegerSchedule.parse(): Schedule \"" + s + "\" illegal", exc);
        }
        catch (IllegalAccessException exc) {
            throw new IllegalArgumentException("IntegerSchedule.parse(): Schedule \"" + s + "\" illegal", exc);
        }
        catch (InstantiationException exc) {
            throw new IllegalArgumentException("IntegerSchedule.parse(): Schedule \"" + s + "\" illegal", exc);
        }
        catch (InvocationTargetException exc) {
            throw new IllegalArgumentException("IntegerSchedule.parse(): Schedule \"" + s + "\" illegal", exc);
        }
        catch (NoSuchMethodException exc) {
            throw new IllegalArgumentException("IntegerSchedule.parse(): Schedule \"" + s + "\" illegal", exc);
        }
    }

    public abstract boolean isFixedSchedule();

    private static String getSubclassName(String name) {
        if (name.equals("fixed")) {
            return "edu.rit.pj.FixedIntegerSchedule";
        }
        if (name.equals("dynamic")) {
            return "edu.rit.pj.DynamicIntegerSchedule";
        }
        if (name.equals("guided")) {
            return "edu.rit.pj.GuidedIntegerSchedule";
        }
        return name;
    }

    void commonStart(int K, Range theLoopRange) {
        this.myBreak = false;
        this.myOrderedIndex = theLoopRange.lb();
        this.start(K, theLoopRange);
    }

    public abstract void start(int var1, Range var2);

    Range commonNext(int theThreadIndex) {
        if (this.myBreak) {
            return null;
        }
        return this.next(theThreadIndex);
    }

    public abstract Range next(int var1);
}

