/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.IntegerSchedule;
import edu.rit.util.Range;
import java.util.concurrent.atomic.AtomicInteger;

class GuidedIntegerSchedule
extends IntegerSchedule {
    private int two_K;
    private Range myLoopRange;
    private int myLoopRangeLength;
    private AtomicInteger N1 = new AtomicInteger();
    private int N2;

    public GuidedIntegerSchedule() {
        this(1);
    }

    public GuidedIntegerSchedule(int theChunkSize) {
        if (theChunkSize < 1) {
            throw new IllegalArgumentException("GuidedIntegerSchedule(): Minimum chunk size = " + theChunkSize + " illegal");
        }
        this.N2 = theChunkSize;
    }

    public GuidedIntegerSchedule(String[] args) {
        this(GuidedIntegerSchedule.getChunkSize(args));
    }

    private static int getChunkSize(String[] args) {
        int theChunkSize;
        if (args.length != 1) {
            throw new IllegalArgumentException("GuidedIntegerSchedule(): Usage: -Dpj.schedule=guided or -Dpj.schedule=\"guided(<n>)\"");
        }
        try {
            theChunkSize = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException exc) {
            throw new IllegalArgumentException("GuidedIntegerSchedule(): Chunk size = " + args[0] + " illegal");
        }
        return theChunkSize;
    }

    @Override
    public boolean isFixedSchedule() {
        return false;
    }

    @Override
    public void start(int K, Range theLoopRange) {
        this.two_K = 2 * K;
        this.myLoopRange = theLoopRange;
        this.myLoopRangeLength = theLoopRange.length();
        this.N1.set(0);
    }

    @Override
    public Range next(int theThreadIndex) {
        Range result;
        int N;
        int newN1;
        int oldN1;
        do {
            if ((N = (result = this.myLoopRange.chunk(oldN1 = this.N1.get(), Math.max(this.N2, (this.myLoopRangeLength - oldN1) / this.two_K))).length()) != 0) continue;
            return null;
        } while (!this.N1.compareAndSet(oldN1, newN1 = oldN1 + N));
        return result;
    }
}

