/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.LongSchedule;
import edu.rit.util.LongRange;
import java.util.concurrent.atomic.AtomicLong;

class DynamicLongSchedule
extends LongSchedule {
    private LongRange myLoopRange;
    private AtomicLong N1 = new AtomicLong();
    private long N2;

    public DynamicLongSchedule() {
        this(1L);
    }

    public DynamicLongSchedule(long theChunkSize) {
        if (theChunkSize < 1L) {
            throw new IllegalArgumentException("DynamicLongSchedule(): Chunk size = " + theChunkSize + " illegal");
        }
        this.N2 = theChunkSize;
    }

    public DynamicLongSchedule(String[] args) {
        this(DynamicLongSchedule.getChunkSize(args));
    }

    private static long getChunkSize(String[] args) {
        long theChunkSize;
        if (args.length != 1) {
            throw new IllegalArgumentException("DynamicLongSchedule(): Usage: -Dpj.schedule=dynamic or -Dpj.schedule=\"dynamic(<n>)\"");
        }
        try {
            theChunkSize = Long.parseLong(args[0]);
        }
        catch (NumberFormatException exc) {
            throw new IllegalArgumentException("DynamicLongSchedule(): Chunk size = " + args[0] + " illegal");
        }
        return theChunkSize;
    }

    @Override
    public boolean isFixedSchedule() {
        return false;
    }

    @Override
    public void start(int K, LongRange theLoopRange) {
        this.myLoopRange = theLoopRange;
        this.N1.set(0L);
    }

    @Override
    public LongRange next(int theThreadIndex) {
        LongRange result;
        long N;
        long newN1;
        long oldN1;
        do {
            if ((N = (result = this.myLoopRange.chunk(oldN1 = this.N1.get(), this.N2)).length()) != 0L) continue;
            return null;
        } while (!this.N1.compareAndSet(oldN1, newN1 = oldN1 + N));
        return result;
    }
}

