/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.Unsigned8BitIntegerBuf;
import edu.rit.mp.buf.SharedUnsigned8BitIntegerArrayReductionBuf;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedIntegerArray;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class SharedUnsigned8BitIntegerArrayBuf
extends Unsigned8BitIntegerBuf {
    SharedIntegerArray myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public SharedUnsigned8BitIntegerArrayBuf(SharedIntegerArray theArray, Range theRange) {
        super(theRange.length());
        this.myArray = theArray;
        this.myRange = theRange;
        this.myArrayOffset = theRange.lb();
        this.myStride = theRange.stride();
    }

    @Override
    public int get(int i) {
        return this.myArray.get(this.myArrayOffset + i * this.myStride);
    }

    @Override
    public void put(int i, int item) {
        this.myArray.set(this.myArrayOffset + i * this.myStride, item);
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new SharedUnsigned8BitIntegerArrayReductionBuf(this.myArray, this.myRange, (IntegerOp)op);
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i * this.myStride;
        while (index < this.myLength && buffer.remaining() >= 1) {
            buffer.put((byte)this.myArray.get(off));
            ++index;
            off += this.myStride;
        }
        return index - i;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i * this.myStride;
        int max = Math.min(i + num, this.myLength);
        while (index < max && buffer.remaining() >= 1) {
            this.myArray.set(off, buffer.get() & 0xFF);
            ++index;
            off += this.myStride;
        }
        return index - i;
    }
}

