/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.SharedSigned8BitIntegerArrayBuf;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedIntegerArray;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

class SharedSigned8BitIntegerArrayReductionBuf
extends SharedSigned8BitIntegerArrayBuf {
    IntegerOp myOp;

    public SharedSigned8BitIntegerArrayReductionBuf(SharedIntegerArray theArray, Range theRange, IntegerOp op) {
        super(theArray, theRange);
        if (op == null) {
            throw new NullPointerException("SharedSigned8BitIntegerArrayReductionBuf(): op is null");
        }
        this.myOp = op;
    }

    @Override
    public void put(int i, int item) {
        this.myArray.reduce(this.myArrayOffset + i * this.myStride, item, this.myOp);
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i * this.myStride;
        int max = Math.min(i + num, this.myLength);
        while (index < max && buffer.remaining() >= 1) {
            this.myArray.reduce(off, buffer.get(), this.myOp);
            ++index;
            off += this.myStride;
        }
        return index - i;
    }
}

