/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ShortBuf;
import edu.rit.mp.buf.SharedShortReductionBuf;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedShort;
import edu.rit.pj.reduction.ShortOp;
import java.nio.ByteBuffer;

public class SharedShortBuf
extends ShortBuf {
    SharedShort myItem;

    public SharedShortBuf(SharedShort item) {
        super(1);
        this.myItem = item;
    }

    @Override
    public short get(int i) {
        return this.myItem.get();
    }

    @Override
    public void put(int i, short item) {
        this.myItem.set(item);
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new SharedShortReductionBuf(this.myItem, (ShortOp)op);
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        if (buffer.remaining() >= 2) {
            buffer.putShort(this.myItem.get());
            return 1;
        }
        return 0;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        if (num >= 1 && buffer.remaining() >= 2) {
            this.myItem.set(buffer.getShort());
            return 1;
        }
        return 0;
    }
}

