/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.SharedShortArrayBuf;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedShortArray;
import edu.rit.pj.reduction.ShortOp;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

class SharedShortArrayReductionBuf
extends SharedShortArrayBuf {
    ShortOp myOp;

    public SharedShortArrayReductionBuf(SharedShortArray theArray, Range theRange, ShortOp op) {
        super(theArray, theRange);
        if (op == null) {
            throw new NullPointerException("SharedShortArrayReductionBuf(): op is null");
        }
        this.myOp = op;
    }

    @Override
    public void put(int i, short item) {
        this.myArray.reduce(this.myArrayOffset + i * this.myStride, item, this.myOp);
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i * this.myStride;
        int max = Math.min(i + num, this.myLength);
        while (index < max && buffer.remaining() >= 2) {
            this.myArray.reduce(off, buffer.getShort(), this.myOp);
            ++index;
            off += this.myStride;
        }
        return index - i;
    }
}

