/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.SharedLongArrayBuf;
import edu.rit.mp.buf.SharedLongArrayReductionBuf_1;
import edu.rit.pj.reduction.LongOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedLongArray;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class SharedLongArrayBuf_1
extends SharedLongArrayBuf {
    public SharedLongArrayBuf_1(SharedLongArray theArray, Range theRange) {
        super(theArray, theRange);
    }

    @Override
    public long get(int i) {
        return this.myArray.get(this.myArrayOffset + i);
    }

    @Override
    public void put(int i, long item) {
        this.myArray.set(this.myArrayOffset + i, item);
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new SharedLongArrayReductionBuf_1(this.myArray, this.myRange, (LongOp)op);
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i;
        while (index < this.myLength && buffer.remaining() >= 8) {
            buffer.putLong(this.myArray.get(off));
            ++index;
            ++off;
        }
        return index - i;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i;
        int max = Math.min(i + num, this.myLength);
        while (index < max && buffer.remaining() >= 8) {
            this.myArray.set(off, buffer.getLong());
            ++index;
            ++off;
        }
        return index - i;
    }
}

