/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.IntegerBuf;
import edu.rit.mp.buf.SharedIntegerArrayReductionBuf;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedIntegerArray;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class SharedIntegerArrayBuf
extends IntegerBuf {
    SharedIntegerArray myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public SharedIntegerArrayBuf(SharedIntegerArray theArray, Range theRange) {
        super(theRange.length());
        this.myArray = theArray;
        this.myRange = theRange;
        this.myArrayOffset = theRange.lb();
        this.myStride = theRange.stride();
    }

    @Override
    public int get(int i) {
        return this.myArray.get(this.myArrayOffset + i * this.myStride);
    }

    @Override
    public void put(int i, int item) {
        this.myArray.set(this.myArrayOffset + i * this.myStride, item);
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new SharedIntegerArrayReductionBuf(this.myArray, this.myRange, (IntegerOp)op);
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i * this.myStride;
        while (index < this.myLength && buffer.remaining() >= 4) {
            buffer.putInt(this.myArray.get(off));
            ++index;
            off += this.myStride;
        }
        return index - i;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i * this.myStride;
        int max = Math.min(i + num, this.myLength);
        while (index < max && buffer.remaining() >= 4) {
            this.myArray.set(off, buffer.getInt());
            ++index;
            off += this.myStride;
        }
        return index - i;
    }
}

